/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.util.CdsTypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.UUID;
import org.apache.olingo.odata2.api.edm.EdmType;

public class TypeConverterUtils {
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss");

    public static Object convertToType(EdmType type, String value) {
        Object typedValue;
        if (value == null) {
            return null;
        }
        switch (type.toString()) {
            case "Edm.Decimal": {
                typedValue = new BigDecimal(value);
                break;
            }
            case "Edm.Double": {
                typedValue = Double.parseDouble(value);
                break;
            }
            case "Edm.Single": {
                typedValue = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case "Edm.Int64": {
                typedValue = Long.parseLong(value);
                break;
            }
            case "Edm.Int32": 
            case "Edm.Int16": 
            case "System.Uint7": 
            case "Edm.Byte": 
            case "Edm.SByte": {
                typedValue = Integer.parseInt(value);
                break;
            }
            case "Edm.Binary": {
                typedValue = value.getBytes(Charset.defaultCharset());
                break;
            }
            case "Edm.String": {
                if (value.length() >= 2 && value.startsWith("'") && value.endsWith("'")) {
                    typedValue = value.substring(1, value.length() - 1);
                    break;
                }
                typedValue = value;
                break;
            }
            case "Edm.TimeOfDay": {
                typedValue = LocalTime.parse(value);
                break;
            }
            case "Edm.Date": {
                typedValue = LocalDate.parse(value);
                break;
            }
            case "Edm.DateTime": {
                typedValue = LocalDate.from(DATE_FORMATTER.parse(value));
                break;
            }
            case "Edm.DateTimeOffset": {
                typedValue = ZonedDateTime.parse(value).toInstant();
                break;
            }
            case "Edm.Boolean": {
                typedValue = Boolean.parseBoolean(value);
                break;
            }
            case "Edm.Guid": {
                typedValue = CdsTypeUtils.parseUuid((Object)value);
                break;
            }
            default: {
                typedValue = value;
            }
        }
        return typedValue;
    }

    public static Object getValueBasedOnTypeOfResultSet(EdmType type, Object value) {
        if (value == null) {
            return null;
        }
        Object typedValue = null;
        switch (type.toString()) {
            case "Edm.Time": {
                if (!(value instanceof LocalTime)) break;
                typedValue = new Calendar.Builder().set(11, ((LocalTime)value).getHour()).set(12, ((LocalTime)value).getMinute()).set(13, ((LocalTime)value).getSecond()).set(14, ((LocalTime)value).getNano() / 1000000).build();
                break;
            }
            case "Edm.DateTime": {
                if (value instanceof LocalDateTime) {
                    Instant instant = ((LocalDateTime)value).toInstant(ZoneOffset.UTC);
                    typedValue = instant.toEpochMilli();
                    break;
                }
                if (!(value instanceof LocalDate)) break;
                typedValue = TypeConverterUtils.toEpochMili((LocalDate)value);
                break;
            }
            case "Edm.DateTimeOffset": {
                if (!(value instanceof Instant)) break;
                try {
                    typedValue = Timestamp.from((Instant)value);
                }
                catch (DateTimeParseException ex) {
                    typedValue = GregorianCalendar.from(ZonedDateTime.parse(value.toString() + "Z"));
                }
                break;
            }
            case "Edm.Guid": {
                typedValue = UUID.fromString(value.toString());
                break;
            }
            default: {
                typedValue = value;
            }
        }
        return typedValue;
    }

    public static Object getValueBasedOnTypeOfRequestPayload(EdmType type, Object value) {
        if (value == null) {
            return null;
        }
        Object typedValue = null;
        switch (type.toString()) {
            case "Edm.Time": {
                if (value instanceof GregorianCalendar) {
                    typedValue = ((GregorianCalendar)value).toZonedDateTime().toLocalTime();
                    break;
                }
                if (!(value instanceof Time)) break;
                typedValue = ((Time)value).toLocalTime();
                break;
            }
            case "Edm.DateTime": {
                if (value instanceof GregorianCalendar) {
                    typedValue = ((GregorianCalendar)value).toZonedDateTime().toLocalDate();
                    break;
                }
                if (!(value instanceof Timestamp)) break;
                typedValue = ((Timestamp)value).toLocalDateTime();
                break;
            }
            case "Edm.DateTimeOffset": {
                if (value instanceof GregorianCalendar) {
                    typedValue = ((GregorianCalendar)value).toInstant();
                    break;
                }
                if (!(value instanceof Timestamp)) break;
                typedValue = ((Timestamp)value).toInstant();
                break;
            }
            case "Edm.Guid": {
                typedValue = CdsTypeUtils.parseUuid((Object)value);
                break;
            }
            default: {
                typedValue = value;
            }
        }
        return typedValue;
    }

    private static Long toEpochMili(LocalDate localDate) {
        return localDate.atStartOfDay().toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

