/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;

public class CdsRequestGlobals {

	public static RequestContext currentContext() {
		if(RequestContext.isActive()) {
			// null is okay, as a RequestContext is currently active
			return RequestContext.getCurrent(null);
		}
		throw new IllegalStateException(); // should never happen
	}

	private final CdsRuntime runtime;
	private final CdsModel model;

	private ApplicationService service;
	private String metadataEtag;

	private final Map<String, String> cdsEntityNames = new HashMap<>();

	public CdsRequestGlobals(CdsRuntime runtime, CdsModel model) {
		this.runtime = runtime;
		this.model = model;
	}

	public CdsRuntime getRuntime() {
		return runtime;
	}

	public CdsModel getModel() {
		return model;
	}

	public ApplicationService getApplicationService() {
		return service;
	}

	public void setApplicationService(ApplicationService service) {
		this.service = service;
	}

	public String getMetadataEtag() {
		return metadataEtag;
	}

	public void setMetadataEtag(String metadataEtag) {
		this.metadataEtag = metadataEtag;
	}

	public Map<String, String> getCdsEntityNames() {
		return this.cdsEntityNames;
	}
}
