/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.IndexContentProviderFactory;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.runtime.CdsRuntimeAware;

public class ODataV2IndexContentProviderFactory implements IndexContentProviderFactory, CdsRuntimeAware {

	private CdsRuntime runtime;

	@Override
	public void setCdsRuntime(CdsRuntime runtime) {
		this.runtime = runtime;
	}

	@Override
	public IndexContentProvider create() {
		return new ODataV2IndexContentProvider(runtime);
	}

	@Override
	public boolean isEnabled() {
		return runtime.getEnvironment().getCdsProperties().getOdataV2().getEndpoint().isEnabled();
	}

}
