/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.processors.response;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.services.ServiceException;

public class CdsODataResponse {

	private final int statusCode;
	private final Result result;
	private final NextLinkInfo nextLinkInfo;
	private final String mimeType;
	private final boolean generateID;

	private Exception exception;

	// SUCCESS
	public CdsODataResponse(int statusCode, Result result) {
		this(statusCode, result, null, null, false);
	}

	public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo, String mimeType, boolean generateID) {
		this.statusCode = statusCode;
		this.result = result;
		this.nextLinkInfo = nextLinkInfo;
		this.mimeType = mimeType;
		this.generateID = generateID;
	}

	// ERRORS
	public CdsODataResponse(Exception e) {
		this(e instanceof ServiceException ? ((ServiceException) e).getErrorStatus().getHttpStatus() : 500, null);
		this.exception = e;
	}

	public boolean isSuccess() {
		return statusCode < 400;
	}

	public int getStatusCode() {
		return statusCode;
	}

	public Result getResult() {
		return result;
	}

	public NextLinkInfo getNextLinkInfo() {
		return nextLinkInfo;
	}

	public String getMimeType() {
		return mimeType;
	}

	public boolean generateID() {
		return generateID;
	}

	public Exception getException() {
		return exception;
	}

}
