/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.query;

import java.util.Map;

import com.sap.cds.adapter.odata.v2.search.SearchParser;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.utils.QueryParameters;
import com.sap.cds.services.utils.StringUtils;

public class CustomQueryLoader {

	private CustomQueryLoader() {
	}

	/**
	 * Add custom query options such as 'search' to select statement.
	 *
	 * @param select      select statement
	 * @param queryParams custom query parameters
	 */
	public static void applySystemQueryOptions(Select<?> select, Map<String, String> queryParams) {
		// search
		String searchString = queryParams.get(QueryParameters.SAP_SEARCH);
		if (!StringUtils.isEmpty(searchString)) {
			CqnPredicate searchPredicate = new SearchParser().parse(searchString);
			select.search(searchPredicate);
		}
	}

}
