/**************************************************************************
 * (C) 2019-2021 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.utils;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ETagParser {

	private static final Pattern ETAG = Pattern.compile("\\s*(,\\s*)+|((?:W/)?\"[!#-~\\x80-\\xFF]*\")");

	private ETagParser() {
		// Private constructor for utility classes
	}

	protected static Collection<String> parse(final Collection<String> values) {
		if (values == null) {
			return Collections.<String> emptySet();
		}

		Set<String> result = new HashSet<>();
		for (final String value : values) {
			final Collection<String> part = parse(value);
			if (part.size() == 1 && "*".equals(part.iterator().next())) {
				return part;
			} else {
				result.addAll(part);
			}
		}
		return result;
	}

	private static Collection<String> parse(final String value) {
		if ("*".equals(value.trim())) {
			return Collections.singleton("*");
		} else {
			Set<String> result = new HashSet<>();
			String separator = "";
			int start = 0;
			Matcher matcher = ETAG.matcher(value.trim());
			while (matcher.find() && matcher.start() == start) {
				start = matcher.end();
				if (matcher.group(1) != null) {
					separator = matcher.group(1);
				} else if (separator != null) {
					result.add(matcher.group(2));
					separator = null;
				} else {
					return Collections.<String> emptySet();
				}
			}
			return matcher.hitEnd() ? result : Collections.<String> emptySet();
		}
	}
}
