/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.IndexContentProvider;
import com.sap.cds.adapter.odata.v2.CdsODataV2ServletFactory;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsDefinition;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.path.CdsServicePath;
import java.io.PrintWriter;
import java.util.stream.Stream;

public class ODataV2IndexContentProvider
implements IndexContentProvider {
    private static final String SERVICE = "                <h3>\n                    <a href=\"%s/\">%s</a>\n                    / <a href=\"%s/$metadata\">$metadata</a>\n                </h3>\n";
    private static final String ENTITY_START = "                <ul>\n";
    private static final String ENTITY = "                    <li>\n                        <a href=\"%s\">%s</a>\n                    </li>\n";
    private static final String ENTITY_END = "                </ul>\n";
    private final CdsRuntime runtime;

    public ODataV2IndexContentProvider(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public String getSectionTitle() {
        return "OData V2 endpoints";
    }

    public void writeContent(PrintWriter out, String contextPath) {
        Stream cdsServicePaths = CdsServicePath.servicePaths((CdsRuntime)this.runtime, (String)"odata-v2");
        CdsODataV2ServletFactory servletFactory = new CdsODataV2ServletFactory();
        servletFactory.setCdsRuntime(this.runtime);
        String basePath = servletFactory.getBasePath();
        String theBasePath = contextPath + (basePath.equals("/") ? "" : basePath);
        cdsServicePaths.filter(p -> p.getCdsDefinition() instanceof CdsService).forEach(s -> {
            String path = theBasePath + "/" + s.getPath();
            out.format(SERVICE, path, path, path);
            out.write(ENTITY_START);
            s.subPaths().filter(e -> this.isExposedEntity(e.getCdsDefinition())).forEach(e -> {
                String entityPath = path + "/" + ODataUtils.toODataName((String)e.getPath());
                out.format(ENTITY, entityPath, e.getPath());
            });
            out.write(ENTITY_END);
        });
    }

    private boolean isExposedEntity(CdsDefinition definition) {
        if (definition instanceof CdsEntity) {
            boolean autoexposed = CdsAnnotations.AUTOEXPOSED.isTrue((CdsAnnotatable)definition);
            boolean autoexpose = CdsAnnotations.AUTOEXPOSE.isTrue((CdsAnnotatable)definition);
            String name = definition.getName();
            return !name.endsWith("_drafts") && !name.endsWith("_texts") && !name.endsWith(".texts") && !name.endsWith("DraftAdministrativeData") && (DraftUtils.isDraftEnabled((CdsEntity)((CdsEntity)definition)) || !autoexposed || autoexpose);
        }
        return false;
    }
}

