/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors.request;

import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;

public class PayloadProcessor {
    public static Map<String, Object> processRequestPayload(EdmType edmType, ODataEntry odataEntry) {
        return (Map)PayloadProcessor.processRow(edmType, odataEntry);
    }

    private static Map<String, Object> processProperty(EdmType edmType, String key, Object value) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        if (value instanceof ODataEntry) {
            finalResult.put(key, PayloadProcessor.processRow(edmType, (ODataEntry)value));
        } else if (value instanceof ODataFeed) {
            ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
            ODataFeed feed = (ODataFeed)value;
            for (ODataEntry entry : feed.getEntries()) {
                list.add(PayloadProcessor.processRequestPayload(edmType, entry));
            }
            finalResult.put(key, list);
        } else {
            finalResult.put(key, TypeConverterUtils.getValueBasedOnTypeOfRequestPayload(edmType, value));
        }
        return finalResult;
    }

    private static Object processRow(EdmType edmType, ODataEntry odataEntry) {
        HashMap resValue = null;
        EdmType type = null;
        try {
            switch (edmType.getKind()) {
                case ENTITY: {
                    EdmEntityType edmEntityType = (EdmEntityType)edmType;
                    List properties = edmEntityType.getPropertyNames();
                    List navProperties = edmEntityType.getNavigationPropertyNames();
                    resValue = new HashMap();
                    for (Map.Entry entry : odataEntry.getProperties().entrySet()) {
                        String key = (String)entry.getKey();
                        Object value = entry.getValue();
                        if (properties.contains(key)) {
                            try {
                                EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(key);
                                type = edmProperty.getType();
                            }
                            catch (EdmException e) {
                                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_EDM_PROPERTY, new Object[]{key, edmEntityType.getName(), e});
                            }
                        }
                        if (navProperties.contains(key)) {
                            try {
                                EdmNavigationProperty edmNavProperty = (EdmNavigationProperty)edmEntityType.getProperty(key);
                                type = edmNavProperty.getType();
                            }
                            catch (EdmException e) {
                                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_EDM_PROPERTY, new Object[]{key, edmEntityType.getName(), e});
                            }
                        }
                        ((Map)resValue).putAll(PayloadProcessor.processProperty(type, key, value));
                    }
                    break;
                }
                default: {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{edmType.getKind().name()});
                }
            }
        }
        catch (EdmException ex) {
            throw new IllegalStateException(ex);
        }
        return resValue;
    }
}

