/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.EdmxReference;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.processors.CdsProcessor;
import com.sap.cds.adapter.odata.v2.processors.ErrorCallback;
import com.sap.cds.adapter.odata.v2.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v2.processors.request.PayloadProcessor;
import com.sap.cds.adapter.odata.v2.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v2.processors.response.ResultSetProcessor;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v2.utils.CheckableInputStream;
import com.sap.cds.adapter.odata.v2.utils.ETagHelper;
import com.sap.cds.adapter.odata.v2.utils.MessagesUtils;
import com.sap.cds.adapter.odata.v2.utils.UriInfoUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EdmProviderAccessor;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.PathSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetFunctionImportUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMediaResourceUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMetadataUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetServiceDocumentUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetSimplePropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.ODataRequestImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.ep.BasicEntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlingoProcessor
extends ODataSingleProcessor {
    private static final Logger accessLogger = LoggerFactory.getLogger((String)"com.sap.cds.adapter.odata.v2.BatchAccess");
    private static final String PREFIX_SAP = "sap";
    private static final String NAMESPACE_SAP = "http://www.sap.com/Protocols/SAPData";
    private static final String[] batchHeaderPropagation = new String[]{"Authorization"};
    private final CdsProcessor cdsProcessor;
    private final CdsRequestGlobals globals;
    private final UriInfoUtils uriUtils;

    public OlingoProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.cdsProcessor = new CdsProcessor(globals);
        this.uriUtils = new UriInfoUtils(this.globals);
    }

    public ODataResponse readEntity(GetEntityUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                if (response.getStatusCode() == 304) {
                    return this.buildODataResponse(request, null, (CdsODataResponse)response, contentType);
                }
                HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                List<Map<String, Object>> data = ResultSetProcessor.postProcessResponsePayload((EdmType)uriInfo.getTargetEntitySet().getEntityType(), response.getResult(), callbacks, serviceRoot, response.generateID(), true);
                EntityProviderWriteProperties writeProperties = this.getPropertiesBuilder(this.getContext(), (UriInfo)uriInfo).callbacks(callbacks).build();
                ODataResponse odataResponse = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), data.get(0), (EntityProviderWriteProperties)writeProperties);
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                NextLinkInfo nextLinkInfo;
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = this.getPropertiesBuilder(this.getContext(), (UriInfo)uriInfo);
                long inlineCount = response.getResult().inlineCount();
                if (inlineCount >= 0L) {
                    propertiesBuilder.inlineCount(Integer.valueOf((int)inlineCount));
                    propertiesBuilder.inlineCountType(InlineCount.ALLPAGES);
                }
                if ((nextLinkInfo = response.getNextLinkInfo()) != null && response.getResult().rowCount() >= (long)nextLinkInfo.getPageSize()) {
                    String skiptoken = "$skiptoken";
                    String odataPath = this.getContext().getPathInfo().getODataSegments().stream().map(e -> e.getPath()).collect(Collectors.joining("/"));
                    Map query = ((ODataRequestImpl)this.getContext().getParameter("~odataRequest")).getQueryParameters();
                    String filteredQuery = query.entrySet().stream().map(e -> (String)e.getKey() + "=" + Encoder.encode((String)((String)e.getValue()))).filter(q -> !q.startsWith("$skiptoken")).collect(Collectors.joining("&"));
                    String skiptokenQuery = "$skiptoken=" + nextLinkInfo.getNextSkipToken();
                    String fullQuery = StringUtils.isEmpty((String)filteredQuery) ? skiptokenQuery : filteredQuery + "&" + skiptokenQuery;
                    String nextLink = odataPath + "?" + fullQuery;
                    propertiesBuilder.nextLink(nextLink);
                }
                HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                List<Map<String, Object>> data = ResultSetProcessor.postProcessResponsePayload((EdmType)uriInfo.getTargetEntitySet().getEntityType(), response.getResult(), callbacks, serviceRoot, response.generateID(), true);
                EntityProviderWriteProperties writeProperties = propertiesBuilder.callbacks(callbacks).build();
                ODataResponse odataResponse = EntityProvider.writeFeed((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), data, (EntityProviderWriteProperties)writeProperties);
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e2) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e2});
            }
            catch (ODataException e3) {
                throw new ServiceException((Throwable)e3);
            }
        });
    }

    public ODataResponse countEntitySet(GetEntitySetCountUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                ODataResponse odataResponse = EntityProvider.writeText((String)OlingoProcessor.toText(response));
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
        });
    }

    public ODataResponse readEntitySimpleProperty(GetSimplePropertyUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                EdmProperty property = UriInfoUtils.getSimpleProperty((UriInfo)uriInfo);
                ODataResponse odataResponse = EntityProvider.writeProperty((String)contentType, (EdmProperty)property, (Object)OlingoProcessor.toSingleValue(response, property));
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
        });
    }

    public ODataResponse readEntitySimplePropertyValue(GetSimplePropertyUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                ODataResponse odataResponse = EntityProvider.writeText((String)OlingoProcessor.toText(response));
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
        });
    }

    public ODataResponse deleteEntity(DeleteUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::delete, response -> this.buildODataResponse(request, null, (CdsODataResponse)response, contentType));
    }

    public ODataResponse createEntity(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) throws ODataException {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
        CheckableInputStream checkableContent = new CheckableInputStream(content);
        try {
            EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(false).build();
            ODataEntry entry = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)((Object)checkableContent), (EntityProviderReadProperties)properties);
            propertiesBuilder.expandSelectTree(entry.getExpandSelectTree());
            request.setBodyMap(PayloadProcessor.processRequestPayload(uriInfo.getTargetType(), entry));
        }
        catch (EntityProviderException e) {
            if (checkableContent.isDataRead()) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage(), e});
            }
            request.setBodyMap(new HashMap<String, Object>());
        }
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::post, response -> {
            try {
                HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                List<Map<String, Object>> data = ResultSetProcessor.postProcessResponsePayload((EdmType)uriInfo.getTargetEntitySet().getEntityType(), response.getResult(), callbacks, serviceRoot);
                propertiesBuilder.callbacks(callbacks).isDataBasedPropertySerialization(true);
                ODataResponse odataResponse = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), data.get(0), (EntityProviderWriteProperties)propertiesBuilder.build());
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse updateEntity(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
        try {
            EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(merge).build();
            ODataEntry entry = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)properties);
            propertiesBuilder.expandSelectTree(entry.getExpandSelectTree());
            request.setBodyMap(PayloadProcessor.processRequestPayload(uriInfo.getTargetType(), entry));
        }
        catch (EntityProviderException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage()});
        }
        return this.cdsProcessor.processRequest(request, merge ? this.cdsProcessor::patch : this.cdsProcessor::put, response -> {
            try {
                ODataResponse odataResponse = null;
                String etag = null;
                if (response.getStatusCode() != 204) {
                    HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                    List<Map<String, Object>> data = ResultSetProcessor.postProcessResponsePayload((EdmType)uriInfo.getTargetEntitySet().getEntityType(), response.getResult(), callbacks, serviceRoot);
                    propertiesBuilder.callbacks(callbacks).isDataBasedPropertySerialization(true);
                    odataResponse = EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), data.get(0), (EntityProviderWriteProperties)propertiesBuilder.build());
                } else {
                    etag = ETagHelper.getEtag((Map<String, Object>)response.getResult().single(), this.globals.getModel().getEntity(request.getLastResourceName()));
                }
                return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType, etag);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse executeFunctionImport(GetFunctionImportUriInfo uriInfo, String contentType) {
        CdsODataRequest cdsRequest = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(cdsRequest, this.cdsProcessor::function, response -> {
            try {
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
                ODataResponse odataResponse = null;
                if (response.getStatusCode() != HttpStatusCodes.NO_CONTENT.getStatusCode()) {
                    EdmFunctionImport functionImport = uriInfo.getFunctionImport();
                    EdmType returnType = functionImport.getReturnType().getType();
                    HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                    List<Map<String, Object>> data = ResultSetProcessor.postProcessResponsePayload(returnType, response.getResult(), callbacks, serviceRoot);
                    odataResponse = EntityProvider.writeFunctionImport((String)contentType, (EdmFunctionImport)uriInfo.getFunctionImport(), (Object)ResultSetProcessor.getReturnValueOfFunction(functionImport, data), (EntityProviderWriteProperties)propertiesBuilder.callbacks(callbacks).build());
                }
                return this.buildODataResponse(cdsRequest, odataResponse, (CdsODataResponse)response, contentType);
            }
            catch (EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readMetadata(GetMetadataUriInfo uriInfo, String contentType) throws ODataException {
        boolean isNotModified = false;
        ODataResponse.ODataResponseBuilder odataResponseBuilder = ODataResponse.newBuilder();
        if (this.globals.getMetadataEtag() != null) {
            odataResponseBuilder.header("ETag", this.globals.getMetadataEtag());
            isNotModified = ETagHelper.checkReadPreconditions(this.globals.getMetadataEtag(), this.getContext().getRequestHeader("If-Match"), this.getContext().getRequestHeader("If-None-Match"));
            odataResponseBuilder.header("Cache-Control", "max-age=0");
        }
        if (isNotModified) {
            odataResponseBuilder.status(HttpStatusCodes.NOT_MODIFIED);
        } else if (this.getContext().getHttpMethod().equalsIgnoreCase("HEAD")) {
            odataResponseBuilder.status(HttpStatusCodes.OK);
        } else {
            HashMap<String, String> predefinedNamespaces = new HashMap<String, String>();
            predefinedNamespaces.put(PREFIX_SAP, NAMESPACE_SAP);
            EdmServiceMetadata edmServiceMetadata = this.getContext().getService().getEntityDataModel().getServiceMetadata();
            EdmProviderAccessor accessor = (EdmProviderAccessor)this.getContext().getService().getEntityDataModel();
            DataServices serviceMetadata = new DataServices();
            serviceMetadata.setDataServiceVersion(edmServiceMetadata.getDataServiceVersion());
            serviceMetadata.setSchemas(accessor.getEdmProvider().getSchemas());
            Map<Integer, EdmxReference> edmxReferences = ((ODataV2EdmProvider)accessor.getEdmProvider()).getEdmxReferencesMap();
            if (!edmxReferences.isEmpty()) {
                serviceMetadata.setAnnotationElements(((ODataV2EdmProvider)accessor.getEdmProvider()).generateAnnotationElement(edmxReferences).getAnnotationElements());
            }
            BasicEntityProvider basicEntityProvider = new BasicEntityProvider();
            ODataResponse odataResponse = basicEntityProvider.writeMetadata(serviceMetadata, predefinedNamespaces);
            ODataResponse.ODataResponseBuilder responseBuilder = ODataResponse.fromResponse((ODataResponse)odataResponse).header("ETag", this.globals.getMetadataEtag()).header("Content-Type", contentType).header("Cache-Control", "max-age=0");
            return responseBuilder.build();
        }
        return odataResponseBuilder.build();
    }

    public ODataResponse readServiceDocument(GetServiceDocumentUriInfo uriInfo, String contentType) throws ODataException {
        boolean isNotModified = false;
        ODataResponse.ODataResponseBuilder odataResponseBuilder = ODataResponse.newBuilder();
        if (this.globals.getMetadataEtag() != null) {
            odataResponseBuilder.header("ETag", this.globals.getMetadataEtag());
            isNotModified = ETagHelper.checkReadPreconditions(this.globals.getMetadataEtag(), this.getContext().getRequestHeader("If-Match"), this.getContext().getRequestHeader("If-None-Match"));
            odataResponseBuilder.header("Cache-Control", "max-age=0");
        }
        if (isNotModified) {
            odataResponseBuilder.status(HttpStatusCodes.NOT_MODIFIED);
        } else if (this.getContext().getHttpMethod().equalsIgnoreCase("HEAD")) {
            odataResponseBuilder.status(HttpStatusCodes.OK);
        } else {
            EdmServiceMetadata edmServiceMetadata = this.getContext().getService().getEntityDataModel().getServiceMetadata();
            ODataResponse odataResponse = super.readServiceDocument(uriInfo, contentType);
            ODataResponse.ODataResponseBuilder responseBuilder = ODataResponse.fromResponse((ODataResponse)odataResponse).header("ETag", this.globals.getMetadataEtag()).header("Content-Type", contentType).header("Cache-Control", "max-age=0").header("DataServiceVersion", edmServiceMetadata.getDataServiceVersion());
            return responseBuilder.build();
        }
        return odataResponseBuilder.build();
    }

    public ODataResponse executeBatch(BatchHandler handler, String contentType, InputStream content) throws ODataException {
        PathInfo pathInfo = this.getContext().getPathInfo();
        EntityProviderBatchProperties batchProperties = EntityProviderBatchProperties.init().pathInfo(pathInfo).build();
        List parts = EntityProvider.parseBatchRequest((String)contentType, (InputStream)content, (EntityProviderBatchProperties)batchProperties);
        ArrayList<BatchResponsePart> responseParts = new ArrayList<BatchResponsePart>();
        for (BatchRequestPart part : parts) {
            for (ODataRequest req : part.getRequests()) {
                for (String header : batchHeaderPropagation) {
                    String parentHeader;
                    if (!StringUtils.isEmpty((String)req.getRequestHeaderValue(header)) || StringUtils.isEmpty((String)(parentHeader = this.getContext().getRequestHeader(header)))) continue;
                    req.getRequestHeaders().put(header, new ArrayList<String>(Arrays.asList(parentHeader)));
                }
            }
            BatchResponsePart responsePart = handler.handleBatchPart(part);
            OlingoProcessor.logBatchRequest(part, responsePart);
            responseParts.add(responsePart);
        }
        return EntityProvider.writeBatchResponse(responseParts);
    }

    public BatchResponsePart executeChangeSet(BatchHandler handler, List<ODataRequest> requests) throws ODataException {
        try {
            return (BatchResponsePart)this.globals.getRuntime().changeSetContext().run(context -> {
                ArrayList<ODataResponse> responses = new ArrayList<ODataResponse>();
                for (ODataRequest request : requests) {
                    ODataResponse response;
                    try {
                        response = handler.handleRequest(request);
                    }
                    catch (ODataException e) {
                        context.markForCancel();
                        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
                    }
                    if (response.getStatus().getStatusCode() >= 200 && response.getStatus().getStatusCode() < 400) {
                        responses.add(response);
                        continue;
                    }
                    context.markForCancel();
                    return BatchResponsePart.responses(Arrays.asList(response)).changeSet(false).build();
                }
                return BatchResponsePart.responses(responses).changeSet(true).build();
            });
        }
        catch (Exception e) {
            ODataErrorContext context2 = new ODataErrorContext();
            context2.setException(e);
            context2.setContentType(ContentType.APPLICATION_XML.toContentTypeString());
            ODataResponse response = new ErrorCallback().handleError(context2);
            return BatchResponsePart.responses(Arrays.asList(response)).changeSet(false).build();
        }
    }

    public ODataResponse readEntityMedia(GetMediaResourceUriInfo getMediaResourceUriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)getMediaResourceUriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::get, response -> {
            try {
                String mimeType = response.getMimeType() == null ? ContentType.APPLICATION_OCTET_STREAM.toContentTypeString() : response.getMimeType();
                InputStream is = OlingoProcessor.toInputStream(response);
                if (null != is) {
                    ODataResponse odataResponse = EntityProvider.writeBinary((String)mimeType, (byte[])IOUtils.toByteArray((InputStream)is));
                    return this.buildODataResponse(request, odataResponse, (CdsODataResponse)response, contentType);
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{this.uriUtils.getTargetEntityName(request.getUriInfo())});
            }
            catch (IOException | EntityProviderException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESPONSE_SERIALIZATION_FAILED, new Object[]{e});
            }
        });
    }

    public ODataResponse deleteEntityMedia(DeleteUriInfo uriInfo, String contentType) {
        CdsODataRequest request = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        return this.cdsProcessor.processRequest(request, this.cdsProcessor::delete, response -> this.buildODataResponse(request, null, (CdsODataResponse)response, contentType));
    }

    public ODataResponse updateEntityMedia(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, String contentType) {
        CdsODataRequest cdsRequest = new CdsODataRequest(this.getContext(), (UriInfo)uriInfo, contentType, this.globals);
        try {
            byte[] binaryContent = EntityProvider.readBinary((InputStream)content);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("$value", binaryContent);
            cdsRequest.setBodyMap(data);
        }
        catch (EntityProviderException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage()});
        }
        return this.cdsProcessor.processRequest(cdsRequest, this.cdsProcessor::patch, response -> this.buildODataResponse(cdsRequest, null, (CdsODataResponse)response, contentType));
    }

    private EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder getPropertiesBuilder(ODataContext oDataContext, UriInfo uriInfo) throws ODataException {
        URI serviceRoot = oDataContext.getPathInfo().getServiceRoot();
        ExpandSelectTreeNode expandSelectTree = UriParser.createExpandSelectTree((List)uriInfo.getSelect(), (List)uriInfo.getExpand());
        return EntityProviderWriteProperties.serviceRoot((URI)serviceRoot).expandSelectTree(expandSelectTree);
    }

    private ODataResponse buildODataResponse(CdsODataRequest cdsRequest, ODataResponse odataResponse, CdsODataResponse cdsResponse, String contentType) {
        return this.buildODataResponse(cdsRequest, odataResponse, cdsResponse, contentType, null);
    }

    private ODataResponse buildODataResponse(CdsODataRequest cdsRequest, ODataResponse odataResponse, CdsODataResponse cdsResponse, String contentType, String etag) {
        ODataResponse.ODataResponseBuilder odataResponseBuilder = null;
        odataResponseBuilder = odataResponse != null ? ODataResponse.fromResponse((ODataResponse)odataResponse) : ODataResponse.newBuilder();
        odataResponseBuilder = odataResponseBuilder.status(HttpStatusCodes.fromStatusCode((int)cdsResponse.getStatusCode())).header("Content-Type", contentType);
        String sapMessageHeader = MessagesUtils.getSapMessagesHeader(CdsRequestGlobals.currentContext().getMessages(), contentType);
        if (!StringUtils.isEmpty((String)sapMessageHeader)) {
            odataResponseBuilder.header("sap-message", sapMessageHeader);
        }
        if (!StringUtils.isEmpty((String)etag)) {
            odataResponseBuilder.header("ETag", etag);
        }
        return odataResponseBuilder.build();
    }

    private static String toText(CdsODataResponse response) {
        return ResultSetProcessor.resultToString(response.getResult());
    }

    private static Object toSingleValue(CdsODataResponse response, EdmProperty property) {
        try {
            return response.getResult().single().get((Object)property.getName());
        }
        catch (EdmException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PAYLOAD, new Object[]{ExceptionUtils.getRootCause((Throwable)e).getLocalizedMessage()});
        }
    }

    private static InputStream toInputStream(CdsODataResponse response) {
        return ResultSetProcessor.rowToSingleValue(response.getResult().first(), InputStream.class);
    }

    private static void logBatchRequest(BatchRequestPart part, BatchResponsePart responsePart) {
        if (accessLogger.isInfoEnabled()) {
            List requests = part.getRequests();
            List responses = responsePart.getResponses();
            for (int i = 0; i < requests.size(); ++i) {
                StringBuilder builder = new StringBuilder();
                ODataRequest request = (ODataRequest)requests.get(i);
                builder.append("$batch ");
                builder.append(request.getMethod()).append(" ");
                builder.append(request.getPathInfo().getODataSegments().stream().map(PathSegment::getPath).collect(Collectors.joining("/")));
                ODataResponse response = responses.size() > i ? (ODataResponse)responses.get(i) : (ODataResponse)responses.get(0);
                builder.append(" ").append(response.getStatus().getStatusCode());
                accessLogger.info(builder.toString());
            }
        }
    }
}

