/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.query;

import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.model.CdsAnnotations;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LimitLookup {
    private final CdsProperties.Query.Limit config;
    private Map<String, Integer> defaultMap = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> maxMap = new ConcurrentHashMap<String, Integer>();

    public LimitLookup(CdsProperties.Query.Limit config) {
        this.config = config;
    }

    public int getDefaultValue(CdsService service, CdsEntity entity) {
        Integer currentValue = this.defaultMap.get(entity.getQualifiedName());
        if (currentValue == null) {
            currentValue = this.getDefaultValueInternal(service, entity);
            this.defaultMap.put(entity.getQualifiedName(), currentValue);
        }
        return currentValue;
    }

    private int getDefaultValueInternal(CdsService service, CdsEntity entity) {
        Object defaultEntity = CdsAnnotations.QUERY_LIMIT_DEFAULT.getOrDefault((CdsAnnotatable)entity);
        if (defaultEntity instanceof Integer) {
            return (Integer)defaultEntity;
        }
        Object defaultService = CdsAnnotations.QUERY_LIMIT_DEFAULT.getOrDefault((CdsAnnotatable)service);
        if (defaultService instanceof Integer) {
            return (Integer)defaultService;
        }
        return this.config.getDefault();
    }

    public int getMaxValue(CdsService service, CdsEntity entity) {
        Integer currentValue = this.maxMap.get(entity.getQualifiedName());
        if (currentValue == null) {
            currentValue = this.getMaxValueInternal(service, entity);
            this.maxMap.put(entity.getQualifiedName(), currentValue);
        }
        return currentValue;
    }

    private int getMaxValueInternal(CdsService service, CdsEntity entity) {
        Object maxEntity = CdsAnnotations.QUERY_LIMIT_MAX.getOrDefault((CdsAnnotatable)entity);
        if (maxEntity instanceof Integer) {
            return (Integer)maxEntity;
        }
        Object maxService = CdsAnnotations.QUERY_LIMIT_MAX.getOrDefault((CdsAnnotatable)service);
        if (maxService instanceof Integer) {
            return (Integer)maxService;
        }
        return this.config.getMax();
    }
}

