/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.mtx;

import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.mtx.AbstractEdmxProviderAccessor;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.ModelId;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.mt.ExtensibilityService;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.request.UserInfo;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static final String V2 = "v2";
    private static Logger log = LoggerFactory.getLogger(MtxEdmxProviderAccessor.class);
    private final MetaDataAccessor<MetadataInfo> accessor;
    private final CdsRuntime runtime;

    public MtxEdmxProviderAccessor(CdsRuntime runtime) {
        this.runtime = runtime;
        MtxUtils mtxUtils = new MtxUtils(runtime);
        SidecarAccess access = mtxUtils.getSidecarAccess();
        CacheParams cacheParams = mtxUtils.getCacheParams();
        this.accessor = new MetaDataAccessorImpl(access, cacheParams, (edmx, service) -> {
            ODataV2EdmProvider edmProvider;
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            try {
                edmProvider = this.loadMetadataFiles(service, edmxBytes);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_V2_MTX, new Object[]{service, e});
            }
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(edmProvider, etag);
        }, null);
        ExtensibilityService extService = (ExtensibilityService)runtime.getServiceCatalog().getService(ExtensibilityService.class, "ExtensibilityService$Default");
        extService.on("MODEL_CHANGED", null, context -> this.accessor.refresh(context.getUserInfo().getTenant()));
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        Locale locale = requestContext.getParameterInfo().getLocale();
        String localeString = locale != null ? LocaleUtils.getLocaleForBundle((Locale)locale).toString() : Locale.ENGLISH.getLanguage();
        UserInfo userInfo = requestContext.getUserInfo();
        String tenant = userInfo.getTenant();
        Set features = requestContext.getFeatureTogglesInfo().getEnabledFeatureToggles().map(ft -> ft.getName()).collect(Collectors.toSet());
        ModelId modelId = ModelId.create((String)tenant).odata(serviceName, localeString, V2).features(features).build();
        int maxAgeSeconds = Integer.MAX_VALUE;
        log.debug("Retrieving model for service name '{}', locale '{}' and features {}", new Object[]{serviceName, localeString, features});
        try {
            return (MetadataInfo)this.accessor.getEdmx(modelId, maxAgeSeconds);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }
}

