/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.processors.ErrorCallback;
import com.sap.cds.adapter.odata.v2.processors.request.CdsODataRequest;
import com.sap.cds.adapter.odata.v2.processors.response.CdsODataResponse;
import com.sap.cds.adapter.odata.v2.query.CustomQueryLoader;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v2.query.SystemQueryLoader;
import com.sap.cds.adapter.odata.v2.utils.AggregateTransformation;
import com.sap.cds.adapter.odata.v2.utils.ETagHelper;
import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.adapter.odata.v2.utils.UriInfoUtils;
import com.sap.cds.impl.DataProcessor;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.AnalysisResult;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.EventContext;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.ListUtils;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.ResultUtils;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.CdsModelUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmSimpleType;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsProcessor {
    public static final String $VALUE = "$value";
    private static final Logger logger = LoggerFactory.getLogger(CdsProcessor.class);
    private static final String CORE_MEDIA_TYPE = "Core.MediaType";
    private final CdsRequestGlobals globals;
    private final UriInfoUtils uriUtils;

    public CdsProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.uriUtils = new UriInfoUtils(globals);
    }

    public ODataResponse processRequest(CdsODataRequest request, Function<CdsODataRequest, CdsODataResponse> cdsProcessor, Function<CdsODataResponse, ODataResponse> responseProcessor) {
        ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
        if (changeSetContext == null) {
            return (ODataResponse)this.globals.getRuntime().changeSetContext().run(context -> this.processInRequestContext(request, cdsProcessor, responseProcessor, (ChangeSetContext)context));
        }
        return this.processInRequestContext(request, cdsProcessor, responseProcessor, changeSetContext);
    }

    private ODataResponse processInRequestContext(CdsODataRequest request, Function<CdsODataRequest, CdsODataResponse> cdsProcessor, Function<CdsODataResponse, ODataResponse> responseProcessor, ChangeSetContext changeSetContext) {
        return (ODataResponse)this.globals.getRuntime().requestContext().clearMessages().parameters((ParameterInfo)request).recalculateFeatureToggles().run(requestContext -> {
            CdsODataResponse response;
            try {
                response = (CdsODataResponse)cdsProcessor.apply(request);
            }
            catch (ServiceException e) {
                this.markForCancel(changeSetContext, e);
                if (e.getErrorStatus().getHttpStatus() >= 500 && e.getErrorStatus().getHttpStatus() < 600) {
                    logger.error(e.getMessage(), (Throwable)e);
                } else {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
                response = new CdsODataResponse((Exception)((Object)e));
            }
            catch (Exception e) {
                this.markForCancel(changeSetContext, e);
                logger.error(e.getMessage(), (Throwable)e);
                response = new CdsODataResponse(e);
            }
            try {
                if (response.isSuccess()) {
                    return (ODataResponse)responseProcessor.apply(response);
                }
                ODataErrorContext context = new ODataErrorContext();
                context.setException(response.getException());
                context.setContentType(request.getContentType());
                return new ErrorCallback().handleError(context);
            }
            catch (Exception e) {
                this.markForCancel(changeSetContext, e);
                throw e;
            }
        });
    }

    private void markForCancel(ChangeSetContext changeSetContext, Throwable e) {
        changeSetContext.markForCancel();
        logger.info("Exception marked the ChangeSet {} as cancelled: {}", (Object)changeSetContext.getId(), (Object)e.getMessage());
    }

    public CdsODataResponse get(CdsODataRequest request) {
        try {
            boolean readById;
            ApplicationService applicationService = this.globals.getApplicationService();
            CdsModel model = this.globals.getModel();
            CdsEntity cdsEntity = model.getEntity(request.getLastResourceName());
            CdsService cdsServiceModel = applicationService.getDefinition();
            UriInfoImpl uriInfo = (UriInfoImpl)request.getUriInfo();
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            Select select = Select.from(this.toPathExpression(request, parameters));
            CdsEntity target = com.sap.cds.services.utils.model.CdsModelUtils.getTargetEntity((CqnStructuredTypeRef)select.ref(), (CdsModel)model);
            NextLinkInfo nextLinkInfo = SystemQueryLoader.applySystemQueryOptions(select, (UriInfo)uriInfo, true, cdsServiceModel, cdsEntity);
            CustomQueryLoader.applySystemQueryOptions(select, request.getQueryParams());
            if (!uriInfo.getPropertyPath().isEmpty()) {
                select.columns(new String[]{UriInfoUtils.getSimpleProperty((UriInfo)uriInfo).getName()});
            } else if (uriInfo.isCount()) {
                select.columns(new Selectable[]{CQL.count().as("count")});
            } else {
                SystemQueryLoader.updateSelectColumns(select, (UriInfo)uriInfo, cdsEntity);
            }
            Optional<CdsElement> etagElement = ETagHelper.getETagElement(cdsEntity);
            boolean bl = readById = uriInfo.getUriType() == UriType.URI2 || uriInfo.getUriType() == UriType.URI6A;
            if (readById && etagElement.isPresent() && ETagHelper.isETagHeaderInRequest(request)) {
                if (ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request)) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
                select = (Select)CqnUtils.modifiedWhere((CqnStatement)select, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement.get())));
            }
            String mimeType = null;
            if (uriInfo.getTargetEntitySet().getEntityType().hasStream()) {
                CdsElement mediaElement = this.getMediaTypeElement(select.ref(), model);
                mimeType = this.getMediaType(mediaElement);
                select.columns(new String[]{mediaElement.getName()});
            }
            AggregateTransformation aggregation = new AggregateTransformation(target, select, (UriInfo)uriInfo);
            boolean isAggregateEntity = aggregation.applyAggregation();
            Result result = applicationService.run((CqnSelect)select, parameters);
            if (readById && etagElement.isPresent() && ETagHelper.isETagHeaderInRequest(request) && result.rowCount() == 0L) {
                if (request.getHeader("If-None-Match") != null) {
                    return new CdsODataResponse(304, result);
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
            if (result.rowCount() == 0L && readById) {
                logger.debug("Entity not found: " + select.ref());
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{request.getLastResourceName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)model, (CqnStatement)select)});
            }
            return new CdsODataResponse(200, result, nextLinkInfo, mimeType, isAggregateEntity);
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public CdsODataResponse post(CdsODataRequest request) {
        try {
            ApplicationService applicationService = this.globals.getApplicationService();
            CdsModel model = this.globals.getModel();
            String qualifiedEntityName = request.getLastResourceName();
            CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
            StructuredType<?> ref = this.toPathExpression(request, new HashMap<String, Object>());
            ref.filter((CqnPredicate)null);
            Insert insert = Insert.into(ref).entry(request.getBodyMap());
            Result result = null;
            result = DraftUtils.isDraftEnabled((CdsAnnotatable)cdsEntity) ? ((DraftService)applicationService).newDraft((CqnInsert)insert) : applicationService.run((CqnInsert)insert);
            return new CdsODataResponse(201, result);
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public CdsODataResponse delete(CdsODataRequest request) {
        try {
            Result result;
            ApplicationService applicationService = this.globals.getApplicationService();
            CdsModel model = this.globals.getModel();
            Delete delete = Delete.from(this.toPathExpression(request, new HashMap<String, Object>()));
            CdsEntity entity = this.globals.getModel().getEntity(request.getLastResourceName());
            Optional<CdsElement> etagElement = ETagHelper.getETagElement(entity);
            if (etagElement.isPresent()) {
                if (ETagHelper.isETagHeaderInRequest(request)) {
                    if (ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request)) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                    }
                    delete = (Delete)CqnUtils.modifiedWhere((CqnStatement)delete, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement.get())));
                } else {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
                }
            }
            if ((result = this.draftEvent(delete.ref(), entity, this.globals.getModel()) ? ((DraftService)applicationService).cancelDraft((CqnDelete)delete, new Object[0]) : applicationService.run((CqnDelete)delete, new Object[0])).rowCount() == 0L) {
                if (etagElement.isPresent()) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
                logger.debug("Entity not found: " + delete.ref());
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_INSTANCE_NOT_FOUND, new Object[]{request.getLastResourceName(), com.sap.cds.services.utils.model.CdsModelUtils.getTargetKeysAsString((CdsModel)model, (CqnStatement)delete)});
            }
            return new CdsODataResponse(204, null);
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public CdsODataResponse put(CdsODataRequest request) {
        try {
            CdsModel model = this.globals.getModel();
            String qualifiedEntityName = request.getLastResourceName();
            CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
            DataUtils dataUtils = DataUtils.create(() -> SessionContextUtils.toSessionContext((RequestContext)CdsRequestGlobals.currentContext()), (int)7);
            DataProcessor processor = DataProcessor.create().addGenerator((p, e, t) -> DataUtils.hasDefaultValue((CdsElement)e, (CdsType)t), (p, e, isNull) -> isNull ? null : dataUtils.defaultValue(e)).action(CdsProcessor::defaultToNull);
            processor.process(request.getBodyMap(), (CdsStructuredType)cdsEntity);
            return this.patchImpl(request, model, cdsEntity);
        }
        catch (EdmException e2) {
            throw new ServiceException((Throwable)e2);
        }
    }

    public CdsODataResponse patch(CdsODataRequest request) {
        try {
            CdsModel model = this.globals.getModel();
            String qualifiedEntityName = request.getLastResourceName();
            CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
            return this.patchImpl(request, model, cdsEntity);
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private CdsODataResponse patchImpl(CdsODataRequest request, CdsModel model, CdsEntity cdsEntity) throws EdmException {
        Map<String, Object> data;
        ApplicationService applicationService = this.globals.getApplicationService();
        StructuredType<?> pathExpression = this.toPathExpression(request, new HashMap<String, Object>());
        AnalysisResult analysis = CqnAnalyzer.create((CdsModel)this.globals.getModel()).analyze((CqnStructuredTypeRef)pathExpression.asRef());
        request.getBodyMap().putAll(analysis.targetKeyValues());
        if (request.getUriInfo().getTargetEntitySet().getEntityType().hasStream() && (data = request.getBodyMap()).containsKey($VALUE)) {
            CdsElement mediaElement = this.getMediaTypeElement((CqnStructuredTypeRef)pathExpression.asRef(), model);
            data.put(mediaElement.getName(), data.remove($VALUE));
        }
        Update update = Update.entity(pathExpression).data(request.getBodyMap());
        Optional<CdsElement> etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement.isPresent()) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                update = (Update)CqnUtils.modifiedWhere((CqnStatement)update, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement.get())));
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
        Result updateResult = this.draftEvent(update.ref(), cdsEntity, model) ? ((DraftService)applicationService).patchDraft((CqnUpdate)update, new Object[0]) : applicationService.run((CqnUpdate)update, new Object[0]);
        long rowCount = updateResult.rowCount();
        if (etagElement.isPresent()) {
            boolean ifNoneMatchAsterisk = ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request);
            if (rowCount == 0L && !ifNoneMatchAsterisk || rowCount > 0L && ifNoneMatchAsterisk) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
        }
        if (rowCount == 0L) {
            return this.post(request);
        }
        return new CdsODataResponse(204, updateResult);
    }

    private static void defaultToNull(CdsStructuredType type, Map<String, Object> data) {
        final ArrayList fkElements = new ArrayList();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnElementRef elementRef) {
                String name;
                if (elementRef.segments().size() == 1 && !"$self".equals(name = elementRef.firstSegment())) {
                    fkElements.add(name);
                }
            }
        };
        type.associations().map(e -> (CdsAssociationType)e.getType().as(CdsAssociationType.class)).map(a -> a.onCondition()).filter(o -> o.isPresent()).map(o -> (CqnPredicate)o.get()).forEach(p -> p.accept(visitor));
        type.elements().filter(e -> !e.isKey()).filter(e -> !e.getType().isAssociation()).filter(e -> CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)e) == null).filter(e -> !fkElements.contains(e.getName())).forEach(e -> data.putIfAbsent(e.getName(), null));
    }

    public CdsODataResponse function(CdsODataRequest request) {
        Result result;
        block10: {
            CdsModel model = this.globals.getModel();
            EdmFunctionImport functionImport = request.getUriInfo().getFunctionImport();
            Map functionParams = request.getUriInfo().getFunctionImportParameters();
            result = null;
            try {
                EventContext context;
                Optional<String> boundEntityName = this.getBoundEntityName(functionImport);
                if (boundEntityName.isPresent()) {
                    String qualifiedEntityName = boundEntityName.get();
                    CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
                    String entityName = ODataUtils.toODataName((String)cdsEntity.getName());
                    String functionName = functionImport.getName();
                    functionName = functionName.substring(entityName.length() + 1);
                    context = EventContext.create((String)functionName, (String)qualifiedEntityName);
                    Set keyNames = CdsModelUtils.keyNames((CdsStructuredType)cdsEntity);
                    Select select = Select.from(this.getPathExpression(cdsEntity, keyNames, functionParams));
                    this.validateETagForWriteWithSelect(request, cdsEntity, (CqnSelect)select);
                    context.put("cqn", (Object)select);
                    functionParams.forEach((key, value) -> {
                        if (!keyNames.contains(key)) {
                            context.put(key, TypeConverterUtils.convertToType((EdmType)value.getType(), value.getLiteral()));
                        }
                    });
                } else {
                    context = EventContext.create((String)functionImport.getName(), null);
                    functionParams.forEach((key, value) -> context.put(key, TypeConverterUtils.convertToType((EdmType)value.getType(), value.getLiteral())));
                }
                this.globals.getApplicationService().emit(context);
                Object returnValue = context.get("result");
                if (functionImport.getReturnType() == null) {
                    return new CdsODataResponse(204, null);
                }
                EdmType returnType = functionImport.getReturnType().getType();
                if (returnValue == null) break block10;
                try {
                    if (returnType instanceof EdmSimpleType) {
                        HashMap<String, Object> data = new HashMap<String, Object>();
                        data.put(functionImport.getName(), returnValue);
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{data}));
                        break block10;
                    }
                    if (returnValue instanceof Iterable) {
                        result = ResultUtils.convert((Iterable)((Iterable)returnValue));
                        break block10;
                    }
                    if (returnValue instanceof Map) {
                        result = ResultUtils.convert((Iterable)ListUtils.getList((Object[])new Map[]{(Map)returnValue}));
                        break block10;
                    }
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName()});
                }
                catch (ClassCastException e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{returnValue.getClass().getName(), e});
                }
            }
            catch (EdmException e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FUNCTION_NOT_FOUND, new Object[]{e});
            }
        }
        return new CdsODataResponse(200, result);
    }

    private Optional<String> getBoundEntityName(EdmFunctionImport functionImport) throws EdmException {
        try {
            if (functionImport.getAnnotations().getAnnotationAttributes() != null) {
                return functionImport.getAnnotations().getAnnotationAttributes().stream().filter(a -> "sap".equals(a.getPrefix()) && "action-for".equals(a.getName())).map(a -> this.globals.getCdsEntityNames().getOrDefault(a.getText(), a.getText())).findFirst();
            }
            return Optional.empty();
        }
        catch (EdmException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.RESOLVING_FUNCTION_IMPORT_ANNOTATION_FAILED, new Object[]{functionImport.getName(), e});
        }
    }

    private StructuredType<?> getPathExpression(CdsEntity rootEntity, Collection<String> keyNames, Map<String, EdmLiteral> functionParams) throws EdmException {
        HashMap keyPairs = new HashMap();
        functionParams.forEach((key, value) -> {
            if (keyNames.contains(key)) {
                keyPairs.put(key, TypeConverterUtils.convertToType((EdmType)value.getType(), value.getLiteral()));
            }
        });
        return CQL.entity((String)rootEntity.getQualifiedName()).matching(keyPairs);
    }

    private void validateETagForWriteWithSelect(CdsODataRequest request, CdsEntity cdsEntity, CqnSelect select) throws EdmException {
        Optional<CdsElement> etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement.isPresent()) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                CqnSelect etagSelect = (CqnSelect)CqnUtils.modifiedWhere((CqnStatement)select, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement.get())));
                Result queryResult = (Result)this.globals.getRuntime().requestContext().clearMessages().run(requestContext -> this.globals.getApplicationService().run(etagSelect, new Object[0]));
                long rowCount = queryResult.rowCount();
                boolean ifNoneMatchAsterisk = ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request);
                if (rowCount == 0L && !ifNoneMatchAsterisk || rowCount > 0L && ifNoneMatchAsterisk) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
    }

    private boolean draftEvent(CqnStructuredTypeRef ref, CdsEntity entity, CdsModel model) {
        Map targetKeys = CqnAnalyzer.create((CdsModel)model).analyze(ref).targetKeyValues();
        return DraftUtils.isDraftEnabled((CdsAnnotatable)entity) && targetKeys.containsKey("IsActiveEntity") && (Boolean)targetKeys.get("IsActiveEntity") == false;
    }

    private StructuredType<?> toPathExpression(CdsODataRequest request, Map<String, Object> parameters) throws EdmException {
        UriInfo uriInfo = request.getUriInfo();
        StructuredType parent = null;
        EdmEntityType rootEntityType = uriInfo.getStartEntitySet().getEntityType();
        Map<String, Object> keys = this.getFilterKeys(uriInfo.getKeyPredicates());
        if (this.uriUtils.isParametersEntityType(rootEntityType)) {
            parameters.putAll(keys);
        } else {
            String entityName = this.uriUtils.getCdsEntityName(rootEntityType);
            parent = CQL.entity((String)entityName).matching(keys);
        }
        for (NavigationSegment segment : uriInfo.getNavigationSegments()) {
            EdmType navigaionType = segment.getNavigationProperty().getType();
            keys = this.getFilterKeys(segment.getKeyPredicates());
            if (navigaionType instanceof EdmEntityType && this.uriUtils.isParametersEntityType((EdmEntityType)navigaionType)) {
                parameters.putAll(keys);
                continue;
            }
            if (parent == null) {
                String entityName = navigaionType instanceof EdmEntityType ? this.uriUtils.getCdsEntityName((EdmEntityType)navigaionType) : segment.getNavigationProperty().getName();
                parent = CQL.entity((String)entityName).matching(keys);
                continue;
            }
            parent = parent.to(segment.getNavigationProperty().getName()).matching(keys);
        }
        if (parent == null) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        return parent;
    }

    private Map<String, Object> getFilterKeys(List<KeyPredicate> keyPredicates) throws EdmException {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        for (KeyPredicate key : keyPredicates) {
            String name = key.getProperty().getName();
            EdmType type = key.getProperty().getType();
            keys.put(name, TypeConverterUtils.convertToType(type, key.getLiteral()));
        }
        return keys;
    }

    private CdsElement getMediaTypeElement(CqnStructuredTypeRef structuredTypeRef, CdsModel model) {
        CdsEntity entity = com.sap.cds.services.utils.model.CdsModelUtils.getTargetEntity((CqnStructuredTypeRef)structuredTypeRef, (CdsModel)model);
        List mediaElements = entity.elements().filter(e -> e.findAnnotation(CORE_MEDIA_TYPE).isPresent()).collect(Collectors.toList());
        if (mediaElements.size() != 1) {
            throw new ServiceException("Number of Core.MediaType elements must be exaclty 1", new Object[0]);
        }
        return (CdsElement)mediaElements.get(0);
    }

    private String getMediaType(CdsElement element) {
        return element.annotations().filter(a -> CORE_MEDIA_TYPE.equals(a.getName())).map(a -> a.getValue().toString()).findFirst().orElseGet(() -> {
            throw new ServiceException(element.getName() + " is not a Core.MediaType element", new Object[0]);
        });
    }
}

