/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.odata.v2.CdsODataV2ServiceFactory;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.path.UrlPathUtil;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Locale;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.servlet.ODataServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsODataV2Servlet
extends ODataServlet {
    public static final String ATTRIBUTE_REQUEST_GLOBALS = "requestGlobals";
    private static final Logger logger = LoggerFactory.getLogger(CdsODataV2Servlet.class);
    private static final long serialVersionUID = 1L;
    private final CdsRuntime runtime;
    private final CdsODataV2ServiceFactory serviceFactory;

    public CdsODataV2Servlet(CdsRuntime runtime) {
        this.runtime = runtime;
        this.serviceFactory = new CdsODataV2ServiceFactory(runtime);
    }

    protected ODataServiceFactory getServiceFactory(HttpServletRequest request) {
        return this.serviceFactory;
    }

    public String getInitParameter(String name) {
        return null;
    }

    protected void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletRequestWrapper wrappedRequest = new HttpServletRequestWrapper(request){

            public String getServletPath() {
                String pathInfo = this.getPathInfo();
                Optional<String> servicePath = CdsODataV2Servlet.this.serviceFactory.getServicePath(pathInfo);
                if (servicePath.isPresent()) {
                    return "/" + servicePath.get();
                }
                return (pathInfo = pathInfo.substring(1)).indexOf("/") != -1 ? "/" + pathInfo.substring(0, pathInfo.indexOf("/")) : "/" + pathInfo;
            }

            public String getContextPath() {
                return UrlPathUtil.normalizeBasePath((String)CdsODataV2Servlet.this.runtime.getEnvironment().getCdsProperties().getOdataV2().getEndpoint().getPath());
            }
        };
        ParameterInfo parameterInfo = this.runtime.getProvidedParameterInfo();
        Locale locale = parameterInfo.getLocale();
        try {
            this.runtime.requestContext().parameters(parameterInfo).run(arg_0 -> this.lambda$service$0((HttpServletRequest)wrappedRequest, response, arg_0));
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
            } else {
                logger.debug("An unexpected error occurred during servlet processing", (Throwable)e);
            }
            this.writeErrorResponse(request, response, httpStatus, e.getLocalizedMessage(locale));
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
            this.writeErrorResponse(request, response, 500, new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(locale));
        }
    }

    private void writeErrorResponse(HttpServletRequest req, HttpServletResponse resp, int httpStatus, String message) throws IOException {
        String responseContent = "<?xml version=\"1.0\" ?><error xmlns=\"http://schemas.microsoft.com/ado/2007/08/dataservices/metadata\"><code>" + httpStatus + "</code><message xml:lang=\"\">" + message + "</message></error>";
        resp.setHeader("Content-Type", ContentType.APPLICATION_XML.toContentTypeString());
        resp.setStatus(httpStatus);
        resp.getWriter().println(responseContent);
    }

    private /* synthetic */ void lambda$service$0(HttpServletRequest wrappedRequest, HttpServletResponse response, RequestContext context) {
        CdsRequestGlobals requestGlobals = new CdsRequestGlobals(this.runtime, context.getModel());
        wrappedRequest.setAttribute(ATTRIBUTE_REQUEST_GLOBALS, (Object)requestGlobals);
        try {
            super.service(wrappedRequest, response);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

