/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.model;

import com.google.common.io.ByteStreams;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.model.AbstractEdmxProviderAccessor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static final Logger log = LoggerFactory.getLogger(DefaultEdmxProviderAccessor.class);
    private final Map<String, MetadataInfo> metadataInfoMap = new ConcurrentHashMap<String, MetadataInfo>();
    private String basePath = "edmx";

    public DefaultEdmxProviderAccessor(CdsRuntime runtime) {
        String configBasePath = runtime.getEnvironment().getCdsProperties().getOdataV2().getEdmxPath();
        if (this.getClass().getClassLoader().getResource(configBasePath) != null) {
            this.basePath = configBasePath;
        }
    }

    @Override
    public MetadataInfo getMetadataInfo(String serviceName) {
        Locale locale = CdsRequestGlobals.currentContext().getParameterInfo().getLocale();
        MetadataInfo info = this.getMetadataInfo(serviceName, locale);
        if (locale != null && (info.getEdmxMetadataProvider() == null || info.getEtag() == null)) {
            info = this.getMetadataInfo(serviceName, null);
        }
        return info;
    }

    private MetadataInfo getMetadataInfo(String unlocalizedServiceName, Locale locale) {
        String serviceName;
        if (locale != null) {
            String language = LocaleUtils.getLocaleForBundle((Locale)locale).toString();
            serviceName = unlocalizedServiceName + "_" + language;
        } else {
            serviceName = unlocalizedServiceName;
        }
        return this.metadataInfoMap.computeIfAbsent(serviceName, key -> {
            byte[] edmxBytes = null;
            ODataV2EdmProvider provider = null;
            String etag = null;
            String resourcePathToEdmx = this.basePath + "/" + serviceName + ".xml";
            InputStream edmxStream = this.getClass().getClassLoader().getResourceAsStream(resourcePathToEdmx);
            if (edmxStream != null) {
                try {
                    edmxBytes = ByteStreams.toByteArray((InputStream)edmxStream);
                    provider = this.loadMetadataFiles(unlocalizedServiceName, edmxBytes);
                    etag = this.calculateMetadataEtag(edmxBytes);
                }
                catch (Exception e) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_V2, new Object[]{resourcePathToEdmx, e});
                }
                finally {
                    try {
                        edmxStream.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close edmx input stream", (Throwable)e);
                    }
                }
            }
            return new MetadataInfo(edmxBytes, provider, etag);
        });
    }
}

