/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.utils.MessagesUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataPreconditionFailedException;
import org.apache.olingo.odata2.api.exception.ODataPreconditionRequiredException;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCallback
implements ODataErrorCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCallback.class);

    public ODataResponse handleError(ODataErrorContext context) {
        ODataPreconditionRequiredException exp;
        Locale locale = CdsRequestGlobals.currentContext().getParameterInfo().getLocale();
        context.setLocale(locale == null ? Locale.ENGLISH : locale);
        if (context.getException().getCause() instanceof EntityProviderException) {
            context.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
            context.setErrorCode(HttpStatusCodes.BAD_REQUEST.name());
        } else if (context.getException() instanceof ServiceException) {
            ErrorCallback.handleWithApplicationEvent(CdsRequestGlobals.currentContext(), context);
        } else if (context.getException() instanceof ODataPreconditionRequiredException) {
            exp = (ODataPreconditionRequiredException)context.getException();
            context.setErrorCode("428001");
            context.setException((Exception)exp);
            context.setHttpStatus(exp.getHttpStatus());
            context.setMessage(exp.getLocalizedMessage());
        } else if (context.getException() instanceof ODataPreconditionFailedException) {
            exp = (ODataPreconditionFailedException)context.getException();
            context.setErrorCode("412001");
            context.setException((Exception)exp);
            context.setHttpStatus(exp.getHttpStatus());
            context.setMessage(exp.getLocalizedMessage());
        }
        int statusCode = context.getHttpStatus().getStatusCode();
        if (statusCode >= 500 && statusCode < 600) {
            LOG.error(context.getMessage(), (Throwable)context.getException());
        } else {
            LOG.debug(context.getMessage(), (Throwable)context.getException());
        }
        ODataResponse odataResponse = EntityProvider.writeErrorDocument((ODataErrorContext)context);
        return ODataResponse.fromResponse((ODataResponse)odataResponse).header("Content-Type", context.getContentType()).status(context.getHttpStatus()).build();
    }

    @VisibleForTesting
    static void handleWithApplicationEvent(RequestContext requestContext, ODataErrorContext errorContext) {
        ApplicationLifecycleService applicationLifecycleService = (ApplicationLifecycleService)requestContext.getServiceCatalog().getService(ApplicationLifecycleService.class, "ApplicationLifecycleService$Default");
        try {
            ErrorResponseEventContext.ErrorResponse response = applicationLifecycleService.errorResponse((ServiceException)((Object)errorContext.getException()));
            Message message = (Message)response.getMessages().get(0);
            errorContext.setHttpStatus(HttpStatusCodes.fromStatusCode((int)response.getHttpStatus()));
            errorContext.setErrorCode(message.getCode());
            errorContext.setSeverity(ErrorCallback.toExternalSeverity(message));
            errorContext.setMessage(message.getMessage());
            errorContext.setTarget(MessagesUtils.getTarget(message.getTarget()));
            errorContext.setErrorDetails((Collection)response.getMessages().stream().skip(1L).map(m -> {
                ODataErrorContext detail = new ODataErrorContext();
                detail.setErrorCode(m.getCode());
                detail.setSeverity(ErrorCallback.toExternalSeverity(m));
                detail.setMessage(m.getMessage());
                detail.setTarget(MessagesUtils.getTarget(m.getTarget()));
                return detail;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            LOG.error("Unexpected exception in error response handling", (Throwable)e);
            ErrorCallback.fallback(requestContext, errorContext);
        }
    }

    private static void fallback(RequestContext requestContext, ODataErrorContext errorContext) {
        ErrorStatusException exp = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
        errorContext.setErrorCode(exp.getErrorStatus().getCodeString());
        errorContext.setException((Exception)exp);
        errorContext.setSeverity(Message.Severity.ERROR.toString().toLowerCase(Locale.ENGLISH));
        errorContext.setHttpStatus(HttpStatusCodes.fromStatusCode((int)exp.getErrorStatus().getHttpStatus()));
        errorContext.setMessage(exp.getLocalizedMessage(requestContext.getParameterInfo().getLocale()));
    }

    private static String toExternalSeverity(Message m) {
        return m.getSeverity().toString().toLowerCase(Locale.ENGLISH);
    }
}

