/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata;

import com.sap.cds.adapter.odata.v2.metadata.EdmxReference;
import com.sap.cds.adapter.odata.v2.metadata.VocabAnnotationElement;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.io.IOUtils;
import org.apache.olingo.odata2.api.edm.FullQualifiedName;
import org.apache.olingo.odata2.api.edm.provider.AnnotationAttribute;
import org.apache.olingo.odata2.api.edm.provider.AnnotationElement;
import org.apache.olingo.odata2.api.edm.provider.Association;
import org.apache.olingo.odata2.api.edm.provider.AssociationSet;
import org.apache.olingo.odata2.api.edm.provider.ComplexType;
import org.apache.olingo.odata2.api.edm.provider.EdmProvider;
import org.apache.olingo.odata2.api.edm.provider.EntityContainer;
import org.apache.olingo.odata2.api.edm.provider.EntityContainerInfo;
import org.apache.olingo.odata2.api.edm.provider.EntitySet;
import org.apache.olingo.odata2.api.edm.provider.EntityType;
import org.apache.olingo.odata2.api.edm.provider.FunctionImport;
import org.apache.olingo.odata2.api.edm.provider.Schema;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.apache.olingo.odata2.core.edm.provider.EdmxProvider;

public class ODataV2EdmProvider
extends EdmProvider {
    private static final String EDM_REFERENCE = "Reference";
    private static final String EDM_INCLUDE = "Include";
    private static final String EDM_NAMESPACE = "Namespace";
    private static final String EDM_ALIAS = "Alias";
    private static final String EDMX_INCLUDE = "edmx:Include";
    private static final String XMLNS_EDMX = "xmlns:edmx";
    private static final String EDMX_REFERENCE = "edmx:Reference";
    private static final String EDMX = "edmx";
    private static final String URI = "Uri";
    private final EdmProvider provider;
    private final Map<Integer, EdmxReference> edmxRefMap;

    public ODataV2EdmProvider(InputStream edmxFile) throws ODataException, XMLStreamException, IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)edmxFile, (OutputStream)byteArrayOutputStream);
        byte[] inputContent = byteArrayOutputStream.toByteArray();
        ByteArrayInputStream inputStream1 = new ByteArrayInputStream(inputContent);
        this.provider = new EdmxProvider().parse((InputStream)inputStream1, true);
        ByteArrayInputStream inputStream2 = new ByteArrayInputStream(inputContent);
        this.edmxRefMap = this.populateEdmxReference(inputStream2);
    }

    private Map<Integer, EdmxReference> populateEdmxReference(InputStream is) throws ODataException, XMLStreamException {
        HashMap<Integer, EdmxReference> edmxRefMap = new HashMap<Integer, EdmxReference>();
        int index = 1;
        XMLStreamReader streamReader = XmlHelper.createStreamReader((Object)is);
        while (streamReader.hasNext()) {
            int i;
            streamReader.next();
            if (streamReader.getEventType() != 1 || !EDM_REFERENCE.equals(streamReader.getLocalName())) continue;
            EdmxReference edmxRef = new EdmxReference();
            if (streamReader.getNamespaceCount() != 0) {
                edmxRef.setNamespacePrefix(streamReader.getNamespacePrefix(0));
                edmxRef.setNamespaceUri(streamReader.getNamespaceURI(0));
            }
            edmxRef.setUri(streamReader.getAttributeValue(0));
            streamReader.next();
            if (streamReader.getEventType() == 1 && EDM_INCLUDE.equals(streamReader.getLocalName())) {
                for (i = 0; i < streamReader.getAttributeCount(); ++i) {
                    if (EDM_NAMESPACE.equals(streamReader.getAttributeName(i).toString())) {
                        edmxRef.setNamespace(streamReader.getAttributeValue(i));
                        continue;
                    }
                    if (!EDM_ALIAS.equals(streamReader.getAttributeName(i).toString())) continue;
                    edmxRef.setAlias(streamReader.getAttributeValue(i));
                }
            } else {
                streamReader.next();
                if (streamReader.getEventType() == 1 && EDM_INCLUDE.equals(streamReader.getLocalName())) {
                    for (i = 0; i < streamReader.getAttributeCount(); ++i) {
                        if (EDM_NAMESPACE.equals(streamReader.getAttributeName(i).toString())) {
                            edmxRef.setNamespace(streamReader.getAttributeValue(i));
                            continue;
                        }
                        if (!EDM_ALIAS.equals(streamReader.getAttributeName(i).toString())) continue;
                        edmxRef.setAlias(streamReader.getAttributeValue(i));
                    }
                }
            }
            edmxRefMap.put(index++, edmxRef);
        }
        return edmxRefMap;
    }

    public Map<Integer, EdmxReference> getEdmxReferencesMap() {
        return this.edmxRefMap;
    }

    public VocabAnnotationElement generateAnnotationElement(Map<Integer, EdmxReference> edmxRefMap) {
        VocabAnnotationElement vocabEle = new VocabAnnotationElement();
        ArrayList<AnnotationElement> annoElements = new ArrayList<AnnotationElement>();
        for (int i = 0; i < edmxRefMap.size(); ++i) {
            EdmxReference edmxRef = edmxRefMap.get(i + 1);
            ArrayList<AnnotationAttribute> childAttributes = new ArrayList<AnnotationAttribute>();
            childAttributes.add(new AnnotationAttribute().setName(EDM_ALIAS).setText(edmxRef.getAlias()));
            childAttributes.add(new AnnotationAttribute().setName(EDM_NAMESPACE).setText(edmxRef.getNamespace()));
            ArrayList<AnnotationAttribute> referenceAttributes = new ArrayList<AnnotationAttribute>();
            ArrayList<AnnotationElement> childElements = new ArrayList<AnnotationElement>();
            childElements.add(new AnnotationElement().setName(EDMX_INCLUDE).setAttributes(childAttributes));
            if (edmxRef.getNamespaceUri() != null) {
                referenceAttributes.add(new AnnotationAttribute().setName(XMLNS_EDMX).setText(edmxRef.getNamespaceUri()));
            }
            referenceAttributes.add(new AnnotationAttribute().setName(URI).setText(edmxRef.getUri()));
            annoElements.add(new AnnotationElement().setName(EDMX_REFERENCE).setPrefix(EDMX).setAttributes(referenceAttributes).setChildElements(childElements));
        }
        vocabEle.setAnnotationElements(annoElements);
        return vocabEle;
    }

    public EntityContainerInfo getEntityContainerInfo(String name) throws ODataException {
        return this.getEntityContainer(this.getSchemas(), name);
    }

    private EntityContainer getEntityContainer(List<Schema> schemas, String name) {
        if (schemas == null) {
            return null;
        }
        for (Schema schema : schemas) {
            List entityContainers = schema.getEntityContainers();
            if (entityContainers == null) {
                return null;
            }
            for (EntityContainer entityContainer : entityContainers) {
                if ((!entityContainer.isDefaultEntityContainer() || name != null) && !entityContainer.getName().equals(name)) continue;
                return entityContainer;
            }
        }
        return null;
    }

    public List<Schema> getSchemas() throws ODataException {
        return this.provider.getSchemas();
    }

    public EntitySet getEntitySet(String entityContainer, String name) throws ODataException {
        EntityContainer container = this.getEntityContainer(this.getSchemas(), entityContainer);
        if (container == null) {
            return null;
        }
        List sets = container.getEntitySets();
        if (sets == null) {
            return null;
        }
        for (EntitySet set : sets) {
            if (!set.getName().equals(name)) continue;
            return set;
        }
        return null;
    }

    public AssociationSet getAssociationSet(String entityContainer, FullQualifiedName association, String sourceEntitySetName, String sourceEntitySetRole) throws ODataException {
        EntityContainer container = this.getEntityContainer(this.getSchemas(), entityContainer);
        if (container == null) {
            return null;
        }
        List sets = container.getAssociationSets();
        if (sets == null) {
            return null;
        }
        for (AssociationSet set : sets) {
            if (!set.getAssociation().getNamespace().equals(association.getNamespace()) || !set.getAssociation().getName().equals(association.getName()) || (!set.getEnd1().getEntitySet().equals(sourceEntitySetName) || !set.getEnd1().getRole().equals(sourceEntitySetRole)) && (!set.getEnd2().getEntitySet().equals(sourceEntitySetName) || !set.getEnd2().getRole().equals(sourceEntitySetRole))) continue;
            return set;
        }
        return null;
    }

    public FunctionImport getFunctionImport(String entityContainer, String name) throws ODataException {
        EntityContainer container = this.getEntityContainer(this.getSchemas(), entityContainer);
        if (container == null) {
            return null;
        }
        List functionImports = container.getFunctionImports();
        if (functionImports == null) {
            return null;
        }
        for (FunctionImport functionImport : functionImports) {
            if (!functionImport.getName().equals(name)) continue;
            return functionImport;
        }
        return null;
    }

    public EntityType getEntityType(FullQualifiedName edmFQName) throws ODataException {
        List<Schema> schemas = this.getSchemas();
        if (schemas == null) {
            return null;
        }
        for (Schema schema : schemas) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            List types = schema.getEntityTypes();
            if (types == null) {
                return null;
            }
            for (EntityType type : types) {
                if (!type.getName().equals(edmFQName.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public ComplexType getComplexType(FullQualifiedName edmFQName) throws ODataException {
        List<Schema> schemas = this.getSchemas();
        if (schemas == null) {
            return null;
        }
        for (Schema schema : schemas) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            List types = schema.getComplexTypes();
            if (types == null) {
                return null;
            }
            for (ComplexType type : types) {
                if (!type.getName().equals(edmFQName.getName())) continue;
                return type;
            }
        }
        return null;
    }

    public Association getAssociation(FullQualifiedName edmFQName) throws ODataException {
        List<Schema> schemas = this.getSchemas();
        if (schemas == null) {
            return null;
        }
        for (Schema schema : schemas) {
            if (!schema.getNamespace().equals(edmFQName.getNamespace())) continue;
            List associations = schemas.get(0).getAssociations();
            if (associations == null) {
                return null;
            }
            for (Association association : associations) {
                if (!association.getName().equals(edmFQName.getName())) continue;
                return association;
            }
        }
        return null;
    }
}

