/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.Selectable;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnSelectListValue;
import com.sap.cds.ql.cqn.CqnSortSpecification;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAnnotation;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.reflect.CdsStructuredType;
import com.sap.cds.reflect.CdsType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsModelUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.uri.SelectItem;
import org.apache.olingo.odata2.api.uri.UriInfo;

public class AggregateTransformation {
    private static final String AGGREGATION_DEFAULT = "Aggregation.default";
    private static final String ANALYTICS_MEASURE = "Analytics.Measure";
    private static final String SUPPORTED_RESTRICTIONS = "Aggregation.ApplySupported.PropertyRestrictions";
    private static final String SAP_AGGREGATION_ROLE = "sap.aggregation-role";
    public static final String AGGREGATE_ID = "ID__";
    private final CdsEntity target;
    private final Select<?> select;
    private final UriInfo uriInfo;
    private List<CqnValue> dimensions;
    private List<CqnSelectListValue> selectListItems;

    public AggregateTransformation(CdsEntity target, Select<?> select, UriInfo uriInfo) {
        this.target = target;
        this.select = select;
        this.uriInfo = uriInfo;
    }

    public boolean applyAggregation() {
        boolean applied = false;
        if (this.isAggregateEntity()) {
            this.dimensions = new ArrayList<CqnValue>();
            this.selectListItems = new ArrayList<CqnSelectListValue>();
            this.uriInfo.getSelect().forEach(this::collectListItems);
            this.select.columns(this.selectListItems);
            this.select.groupBy(this.dimensions);
            this.select.orderBy(this.getOrderBy());
            applied = true;
        }
        if (this.uriInfo.isCount()) {
            this.select.columns(new Selectable[]{CQL.count().as("count")});
        }
        return applied;
    }

    private void collectListItems(SelectItem i) {
        try {
            String itemName = i.getProperty().getName();
            if (AggregateTransformation.isAggregateID(itemName, this.target)) {
                return;
            }
            this.target.getQualifier();
            ElementRef ref = CQL.get((String)itemName);
            CdsElement element = this.target.getElement(itemName);
            if (this.isMeasure(element)) {
                this.selectListItems.add(this.toFunctionCall(element).as(itemName));
            } else {
                this.selectListItems.add((CqnSelectListValue)ref);
                this.dimensions.add((CqnValue)ref);
            }
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private Value<?> toFunctionCall(CdsElement element) {
        Value functionCall;
        String methodName;
        ElementRef ref = ElementRefImpl.element((String[])new String[]{element.getName()});
        switch (methodName = this.getAggregation(element)) {
            case "AVG": 
            case "AVERAGE": {
                functionCall = ref.average();
                break;
            }
            case "COUNT": {
                functionCall = CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref}).type(Long.class);
                break;
            }
            case "COUNT_DISTINCT": {
                functionCall = ref.countDistinct();
                break;
            }
            case "MAX": 
            case "MIN": 
            case "SUM": {
                functionCall = CQL.func((String)methodName, (CqnValue[])new CqnValue[]{ref});
                this.type((Value<?>)ref).ifPresent(arg_0 -> ((Value)functionCall).type(arg_0));
                break;
            }
            default: {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNKONWN_AGGREGATION_METHOD, new Object[]{methodName});
            }
        }
        return functionCall;
    }

    private Optional<CdsBaseType> type(Value<?> value) {
        CdsElement element;
        CdsType t;
        if (value.isRef() && (t = (element = CdsModelUtils.element((CdsStructuredType)this.target, (CqnElementRef)value.asRef())).getType()).isSimple()) {
            return Optional.ofNullable(((CdsSimpleType)t.as(CdsSimpleType.class)).getType());
        }
        return Optional.empty();
    }

    private boolean isAggregateEntity() {
        return this.getAnnotatedValue((CdsAnnotatable)this.target, SUPPORTED_RESTRICTIONS, false);
    }

    private boolean isMeasure(CdsElement element) {
        boolean isAnalyticsMeasure = this.getAnnotatedValue((CdsAnnotatable)element, ANALYTICS_MEASURE, false);
        if (isAnalyticsMeasure) {
            return true;
        }
        return "measure".equals(this.getAnnotatedValue((CdsAnnotatable)element, SAP_AGGREGATION_ROLE, ""));
    }

    private String getAggregation(CdsElement element) {
        Map<String, String> annotatedValue = this.getAnnotatedValue((CdsAnnotatable)element, AGGREGATION_DEFAULT, Collections.singletonMap("#", "#"));
        return annotatedValue.get("#");
    }

    private <T> T getAnnotatedValue(CdsAnnotatable annotatable, String annotation, T fallBackValue) {
        try {
            return (T)annotatable.findAnnotation(annotation).map(CdsAnnotation::getValue).orElse(fallBackValue);
        }
        catch (ClassCastException ex) {
            throw new ServiceException("The type of annotation value for " + annotatable + " is not a " + fallBackValue.getClass().getName(), new Object[]{ex});
        }
    }

    private List<CqnSortSpecification> getOrderBy() {
        return this.select.orderBy().stream().map(this::getItem).collect(Collectors.toList());
    }

    private CqnSortSpecification getItem(CqnSortSpecification orderByItem) {
        return this.select.items().stream().filter(item -> item.asValue().displayName().equals(orderByItem.value().asRef().displayName())).findFirst().map(sli -> CQL.sort((CqnValue)sli.asValue().value(), (CqnSortSpecification.Order)orderByItem.order())).orElseGet(() -> orderByItem);
    }

    public static boolean isAggregateID(String element, CdsEntity entity) {
        return AGGREGATE_ID.equals(element) && !entity.findElement(element).isPresent();
    }
}

