/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors.request;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.utils.UriInfoUtils;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.utils.CorrelationIdUtils;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.TemporalRangeUtils;
import java.time.Instant;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.uri.UriInfo;

public class CdsODataRequest
implements ParameterInfo {
    private final ODataContext odataContext;
    private final UriInfo uriInfo;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final String contentType;
    private Map<String, Object> bodyMap;
    private String correlationId;
    private Locale locale;
    private Instant validFrom;
    private Instant validTo;
    private final CdsRequestGlobals globals;
    private final UriInfoUtils uriUtils;

    public CdsODataRequest(ODataContext odataContext, UriInfo uriInfo, String contentType, CdsRequestGlobals globals) {
        this.odataContext = odataContext;
        this.uriInfo = uriInfo;
        this.contentType = contentType;
        this.globals = globals;
        this.uriUtils = new UriInfoUtils(this.globals);
        ODataRequest odataRequest = (ODataRequest)odataContext.getParameter("~odataRequest");
        this.queryParameters.putAll(odataRequest.getQueryParameters().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Optional.ofNullable(this.getHeader((String)e.getKey())).orElse((String)e.getValue()))));
    }

    public String getLastResourceName() {
        String resourceName = this.uriUtils.getTargetEntityName(this.uriInfo);
        String cdsName = this.globals.getCdsEntityNames().get(resourceName);
        if (cdsName != null) {
            resourceName = cdsName;
        }
        return resourceName;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setBodyMap(Map<String, Object> data) {
        this.bodyMap = data;
    }

    public Map<String, Object> getBodyMap() {
        return this.bodyMap;
    }

    public String getCorrelationId() {
        if (this.correlationId == null) {
            this.correlationId = CorrelationIdUtils.getOrGenerateCorrelationId((ParameterInfo)this);
        }
        return this.correlationId;
    }

    public String getHeader(String id) {
        return this.odataContext.getRequestHeader(id);
    }

    public Map<String, String> getHeaders() {
        return this.odataContext.getRequestHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getHeader((String)e.getKey())));
    }

    public String getQueryParameter(String key) {
        return this.queryParameters.get(key);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParameters;
    }

    public Stream<String> getQueryParameters() {
        return this.queryParameters.keySet().stream();
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = new LocaleUtils(this.globals.getRuntime().getEnvironment().getCdsProperties()).getLocale(this.getQueryParameter("sap-locale"), this.getHeader("Accept-Language"), this.getQueryParameter("sap-language"), this.getHeader("x-sap-request-language"));
        }
        return this.locale;
    }

    public Instant getValidFrom() {
        if (this.validFrom == null) {
            this.initTemporalRange();
        }
        return this.validFrom;
    }

    public Instant getValidTo() {
        if (this.validTo == null) {
            this.initTemporalRange();
        }
        return this.validTo;
    }

    private void initTemporalRange() {
        Instant[] range = TemporalRangeUtils.getTemporalRanges((String)this.getQueryParameter("sap-valid-from"), (String)this.getQueryParameter("sap-valid-to"), (String)this.getQueryParameter("sap-valid-at"));
        this.validFrom = range[0];
        this.validTo = range[1];
    }
}

