/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.ErrorCallback;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.processors.OlingoProcessor;
import com.sap.cds.feature.mt.v2.EdmxProviderAccessor;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceCatalog;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.CdsService;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import com.sap.cds.services.utils.path.CdsServicePath;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.ODataService;
import org.apache.olingo.odata2.api.ODataServiceFactory;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CdsODataV2ServiceFactory
extends ODataServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(CdsODataV2ServiceFactory.class);
    private static final String METADATA_URL = "$metadata";
    private static final String PATHINFO = "~pathInfo";
    private final CdsRuntime cdsRuntime;

    public CdsODataV2ServiceFactory(CdsRuntime cdsRuntime) {
        this.cdsRuntime = cdsRuntime;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ODataService createService(ODataContext context) throws ODataException {
        Locale locale = this.cdsRuntime.getProvidedParameterInfo().getLocale();
        try (CdsRequestGlobals requestGlobals = CdsRequestGlobals.create();){
            requestGlobals.setRuntime(this.cdsRuntime);
            requestGlobals.setLocale(locale);
            String tenant = this.cdsRuntime.getProvidedUserInfo().getTenant();
            requestGlobals.setTenant(tenant);
            HttpServletRequest request = (HttpServletRequest)context.getParameter("~httpRequestObject");
            ServiceCatalog serviceCatalog = this.cdsRuntime.getServiceCatalog();
            Map<String, CdsService> servicePaths = CdsServicePath.calcServicePaths((CdsModel)this.cdsRuntime.getCdsModel()).collect(Collectors.toMap(servicePath -> servicePath.getPath(), servicePath -> (CdsService)serviceCatalog.getService(CdsService.class, servicePath.getCdsDefinition().getQualifiedName())));
            String language = locale != null ? locale.getLanguage() : null;
            PathInfo path = (PathInfo)context.getParameter(PATHINFO);
            String pathInfo = path.getRequestUri().getPath();
            if (pathInfo == null) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_URI_RESOURCE, new Object[0]);
            }
            MutablePair<CdsService, String> serviceInfo = this.extractServiceInfo(request.getPathInfo(), servicePaths);
            CdsService cdsService = (CdsService)serviceInfo.getLeft();
            String serviceName = cdsService.getName();
            requestGlobals.setCdsService(cdsService);
            ODataV2EdmProvider edm = null;
            EdmxProviderAccessor accessor = EdmxProviderAccessor.getInstance();
            if (pathInfo.endsWith(METADATA_URL) && language != null) {
                String localizedServiceName = serviceName + "_" + language;
                edm = accessor.getEdmxMetadataProvider(localizedServiceName);
            }
            if (null == edm) {
                edm = accessor.getEdmxMetadataProvider(serviceName);
            }
            if (null == edm) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{serviceName});
            }
            ODataService oDataService = this.createODataSingleProcessorService(edm, new OlingoProcessor(requestGlobals));
            return oDataService;
        }
        catch (ServiceException e) {
            int httpStatus = e.getErrorStatus().getHttpStatus();
            if (httpStatus >= 500 && httpStatus < 600) {
                logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
                return null;
            }
            logger.debug("An unexpected error occurred during servlet processing", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            logger.error("An unexpected error occurred during servlet processing", (Throwable)e);
        }
        return null;
    }

    private MutablePair<CdsService, String> extractServiceInfo(String pathInfo, Map<String, CdsService> servicePaths) {
        String servicePath;
        CdsService service;
        if (pathInfo.trim().isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_FOUND, new Object[0]);
        }
        String path = StringUtils.trim((String)pathInfo.trim(), (char)'/');
        Optional<String> servicePathKey = servicePaths.keySet().stream().sorted((a, b) -> -1 * Integer.compare(a.length(), b.length())).filter(p -> path.startsWith((String)p)).findFirst();
        if (servicePathKey.isPresent() && (service = servicePaths.get(servicePath = servicePathKey.get())) != null) {
            return MutablePair.of((Object)service, (Object)servicePath);
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SERVICE_NOT_FOUND, new Object[]{path});
    }

    public <T extends ODataCallback> T getCallback(Class<T> callbackInterface) {
        return (T)(callbackInterface.isAssignableFrom(ErrorCallback.class) ? new ErrorCallback() : super.getCallback(callbackInterface));
    }
}

