/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.cds.CdsService;
import com.sap.cds.services.runtime.CdsRuntime;
import java.util.Locale;

public class CdsRequestGlobals
implements AutoCloseable {
    private CdsRuntime runtime;
    private CdsService service;
    private Locale locale;
    private String tenant;
    private CdsRequestGlobals prevGlobals;
    private static final ThreadLocal<CdsRequestGlobals> requestGlobal = new ThreadLocal();

    public static CdsRequestGlobals current() {
        return requestGlobal.get();
    }

    public static String currentTenant() {
        return CdsRequestGlobals.current() != null ? CdsRequestGlobals.current().getTenant() : null;
    }

    public static CdsModel currentModel() {
        return CdsRequestGlobals.current() != null ? CdsRequestGlobals.current().getRuntime().getCdsModel(CdsRequestGlobals.currentTenant()) : null;
    }

    public static CdsRequestGlobals create() {
        CdsRequestGlobals globals = new CdsRequestGlobals();
        globals.prevGlobals = CdsRequestGlobals.current();
        requestGlobal.set(globals);
        return globals;
    }

    @Override
    public void close() {
        requestGlobal.set(this.prevGlobals);
    }

    public CdsService getCdsService() {
        return this.service;
    }

    public void setCdsService(CdsService service) {
        this.service = service;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public String getTenant() {
        return this.tenant;
    }

    public void setTenant(String tenant) {
        this.tenant = tenant;
    }

    public CdsRuntime getRuntime() {
        return this.runtime;
    }

    public void setRuntime(CdsRuntime runtime) {
        this.runtime = runtime;
    }
}

