/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2;

import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.ErrorStatusException;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCallback
implements ODataErrorCallback {
    private static final Logger LOG = LoggerFactory.getLogger(ErrorCallback.class);

    public ODataResponse handleError(ODataErrorContext context) throws ODataApplicationException {
        if (context.getException().getCause() instanceof EntityProviderException) {
            context.setHttpStatus(HttpStatusCodes.BAD_REQUEST);
            context.setErrorCode(HttpStatusCodes.BAD_REQUEST.name());
        } else if (context.getException() instanceof ErrorStatusException) {
            ErrorStatusException exp = (ErrorStatusException)context.getException();
            context.setErrorCode(String.valueOf(exp.getErrorStatus().getCode()));
            context.setHttpStatus(HttpStatusCodes.fromStatusCode((int)exp.getErrorStatus().getHttpStatus()));
            context.setMessage(exp.getMessage());
            context.setException((Exception)exp);
        } else if (context.getException() instanceof ServiceException) {
            ServiceException exp = (ServiceException)((Object)context.getException());
            context.setErrorCode(String.valueOf(exp.getErrorStatus().getCode()));
            context.setException((Exception)((Object)exp));
            context.setHttpStatus(HttpStatusCodes.fromStatusCode((int)exp.getErrorStatus().getHttpStatus()));
            context.setMessage(exp.getLocalizedMessage());
        }
        LOG.error(context.getMessage(), (Throwable)context.getException());
        return EntityProvider.writeErrorDocument((ODataErrorContext)context);
    }
}

