/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.utils.LocaleUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.api.uri.UriInfo;

public class CdsODataRequest
implements ParameterInfo {
    private final CdsRequestGlobals globals;
    private RequestContext requestContext;
    private final UriInfo uriInfo;
    private final String contentType;
    private Map<String, Object> bodyMap;
    private final Map<String, String> queryParameters = new HashMap<String, String>();
    private final ODataContext odataContext;
    private Locale locale;

    public CdsODataRequest(ODataContext odataContext, UriInfo uriInfo, String contentType, CdsRequestGlobals globals) {
        this.uriInfo = uriInfo;
        this.contentType = contentType;
        this.globals = globals;
        this.odataContext = odataContext;
        this.queryParameters.putAll(uriInfo.getCustomQueryOptions().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getHeader((String)e.getKey()))));
    }

    public RequestContext getRequestContext() {
        return this.requestContext;
    }

    public void setRequestContext(RequestContext requestContext) {
        this.requestContext = requestContext;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getName() {
        try {
            String namespace = this.uriInfo.getStartEntitySet().getEntityType().getNamespace();
            String name = this.uriInfo.getStartEntitySet().getEntityType().getName();
            return namespace + "." + name;
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public String getLastResourceName() {
        try {
            String namespace = this.uriInfo.getTargetEntitySet().getEntityType().getNamespace();
            String name = this.uriInfo.getTargetEntitySet().getEntityType().getName();
            return namespace + "." + name;
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public List<NavigationSegment> getNavigationSegments() {
        return this.uriInfo.getNavigationSegments();
    }

    public EdmEntitySet getTargetEntitySet() {
        return this.uriInfo.getTargetEntitySet();
    }

    public CdsRequestGlobals getGlobals() {
        return this.globals;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public void setBodyMap(Map<String, Object> data) {
        this.bodyMap = data;
    }

    public Map<String, Object> getBodyMap() {
        return this.bodyMap;
    }

    public String getHeader(String id) {
        return this.odataContext.getRequestHeader(id);
    }

    public Map<String, String> getHeaders() {
        return this.odataContext.getRequestHeaders().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.getHeader((String)e.getKey())));
    }

    public String getQueryParameter(String key) {
        return this.queryParameters.get(key);
    }

    public Map<String, String> getQueryParams() {
        return this.queryParameters;
    }

    public Stream<String> getQueryParameters() {
        return this.queryParameters.keySet().stream();
    }

    public Locale getLocale() {
        if (this.locale == null) {
            this.locale = LocaleUtils.getLocale((String)this.getQueryParameter("sap-language"), (String)this.getHeader("x-sap-request-language"), (String)this.getHeader("Accept-Language"));
        }
        return this.locale;
    }
}

