/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.processors.CdsODataRequest;
import com.sap.cds.adapter.odata.v2.processors.CdsODataResponse;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v2.query.SystemQueryLoader;
import com.sap.cds.adapter.odata.v2.utils.ETagHelper;
import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.adapter.odata.v2.utils.UriInfoUtils;
import com.sap.cds.impl.DataTraverser;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.Delete;
import com.sap.cds.ql.Insert;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.StructuredType;
import com.sap.cds.ql.Update;
import com.sap.cds.ql.cqn.CqnAnalyzer;
import com.sap.cds.ql.cqn.CqnDelete;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnInsert;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnSelect;
import com.sap.cds.ql.cqn.CqnSelectListItem;
import com.sap.cds.ql.cqn.CqnStatement;
import com.sap.cds.ql.cqn.CqnStructuredTypeRef;
import com.sap.cds.ql.cqn.CqnUpdate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.ql.cqn.CqnVisitor;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsAssociationType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.cds.CdsService;
import com.sap.cds.services.draft.DraftService;
import com.sap.cds.services.request.ParameterInfo;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.DraftUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.SessionContextUtils;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.services.utils.model.CqnUtils;
import com.sap.cds.util.DataUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.uri.KeyPredicate;
import org.apache.olingo.odata2.api.uri.NavigationSegment;
import org.apache.olingo.odata2.core.uri.UriInfoImpl;
import org.apache.olingo.odata2.core.uri.UriType;

public class CdsProcessor {
    public static final String COUNT_ALIAS = "count";

    private static CdsODataResponse processInRequestContext(CdsODataRequest cdsRequest, Supplier<CdsODataResponse> requestHandler) {
        return (CdsODataResponse)cdsRequest.getGlobals().getRuntime().requestContext().parameters((ParameterInfo)cdsRequest).run(requestContext -> {
            cdsRequest.setRequestContext((RequestContext)requestContext);
            return (CdsODataResponse)requestHandler.get();
        });
    }

    public CdsODataResponse get(CdsODataRequest request) {
        return CdsProcessor.processInRequestContext(request, () -> {
            try {
                boolean readById;
                CdsRequestGlobals globals = request.getGlobals();
                CdsService cdsService = globals.getCdsService();
                CdsModel model = globals.getRuntime().getCdsModel();
                com.sap.cds.reflect.CdsService cdsServiceModel = model.getService(cdsService.getName());
                Select select = Select.from(CdsProcessor.toPathExpression(request, model));
                NextLinkInfo nextLinkInfo = SystemQueryLoader.applySystemQueryOptions(select, request.getUriInfo(), true, cdsServiceModel, model.getEntity(request.getLastResourceName()));
                if (!request.getUriInfo().getPropertyPath().isEmpty()) {
                    select.columns(new String[]{UriInfoUtils.getSimpleProperty(request).getName()});
                } else if (request.getUriInfo().isCount()) {
                    select.columns(new CqnSelectListItem[]{CQL.func((String)"COUNT", (CqnValue[])new CqnValue[]{CQL.plain((String)"*")}).as(COUNT_ALIAS)});
                } else {
                    SystemQueryLoader.updateSelectColumns(select, request.getUriInfo(), model.getEntity(request.getLastResourceName()));
                }
                CdsElement etagElement = ETagHelper.getETagElement(model.getEntity(request.getLastResourceName()));
                boolean bl = readById = ((UriInfoImpl)request.getUriInfo()).getUriType() == UriType.URI2 || ((UriInfoImpl)request.getUriInfo()).getUriType() == UriType.URI6A;
                if (readById && etagElement != null && ETagHelper.isETagHeaderInRequest(request)) {
                    if (ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request)) {
                        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                    }
                    select = (Select)CqnUtils.modifiedWhere((CqnStatement)select, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
                }
                Result result = cdsService.run((CqnSelect)select, new Object[0]);
                if (readById && etagElement != null && ETagHelper.isETagHeaderInRequest(request) && result.rowCount() == 0L) {
                    if (request.getHeader("If-None-Match") != null) {
                        return new CdsODataResponse(304, result);
                    }
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
                }
                if (result.rowCount() == 0L && readById) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{select.ref()});
                }
                CdsEntity target = CqnAnalyzer.create((CdsModel)model).analyze(select.ref()).targetEntity();
                return new CdsODataResponse(200, TypeConverterUtils.convertResultTypes(target, (Iterable<Row>)result), nextLinkInfo);
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public CdsODataResponse post(CdsODataRequest request) {
        return CdsProcessor.processInRequestContext(request, () -> {
            try {
                CdsRequestGlobals globals = request.getGlobals();
                CdsService cdsService = globals.getCdsService();
                CdsModel model = globals.getRuntime().getCdsModel();
                String qualifiedEntityName = request.getLastResourceName();
                CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
                Map<String, Object> data = TypeConverterUtils.convertRequestPayloadTypes(cdsEntity, request.getBodyMap());
                Insert insert = Insert.into(CdsProcessor.toPathExpression(request, model)).entry(data);
                Result result = null;
                result = DraftUtils.isDraftEnabled((CdsEntity)cdsEntity) ? ((DraftService)cdsService).newDraft((CqnInsert)insert) : cdsService.run((CqnInsert)insert);
                return new CdsODataResponse(201, TypeConverterUtils.convertResultTypes(cdsEntity, (Iterable<Row>)result));
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public CdsODataResponse delete(CdsODataRequest request) {
        return CdsProcessor.processInRequestContext(request, () -> {
            try {
                CdsRequestGlobals globals = request.getGlobals();
                CdsService cdsService = globals.getCdsService();
                CdsModel model = globals.getRuntime().getCdsModel();
                Delete delete = Delete.from(CdsProcessor.toPathExpression(request, model));
                Result result = cdsService.run((CqnDelete)delete, new Object[0]);
                if (result.rowCount() == 0L) {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ENTITY_NOT_FOUND, new Object[]{delete.ref()});
                }
                return new CdsODataResponse(204, null);
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public CdsODataResponse put(CdsODataRequest request) {
        return CdsProcessor.processInRequestContext(request, () -> {
            try {
                CdsRequestGlobals globals = request.getGlobals();
                CdsModel model = globals.getRuntime().getCdsModel();
                String qualifiedEntityName = request.getLastResourceName();
                CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
                TypeConverterUtils.convertRequestPayloadTypes(cdsEntity, request.getBodyMap());
                DataUtils dataUtils = DataUtils.create(() -> SessionContextUtils.toSessionContext((RequestContext)request.getRequestContext()));
                DataTraverser.Action[] actionArray = new DataTraverser.Action[2];
                actionArray[0] = (arg_0, arg_1) -> ((DataUtils)dataUtils).defaultValues(arg_0, arg_1);
                actionArray[1] = CdsProcessor::defaultToNull;
                DataTraverser traverser = new DataTraverser(actionArray);
                traverser.traverse(cdsEntity, Arrays.asList(request.getBodyMap()));
                return this.patchImpl(request, model, cdsEntity);
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public CdsODataResponse patch(CdsODataRequest request) {
        try {
            CdsRequestGlobals globals = request.getGlobals();
            CdsModel model = globals.getRuntime().getCdsModel();
            String qualifiedEntityName = request.getLastResourceName();
            CdsEntity cdsEntity = model.getEntity(qualifiedEntityName);
            TypeConverterUtils.convertRequestPayloadTypes(cdsEntity, request.getBodyMap());
            return this.patchImpl(request, model, cdsEntity);
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private CdsODataResponse patchImpl(CdsODataRequest request, CdsModel model, CdsEntity cdsEntity) throws EdmException {
        CdsRequestGlobals globals = request.getGlobals();
        CdsService cdsService = globals.getCdsService();
        StructuredType<?> pathExpression = CdsProcessor.toPathExpression(request, model);
        Update update = Update.entity(pathExpression).data(request.getBodyMap());
        CdsElement etagElement = ETagHelper.getETagElement(cdsEntity);
        if (etagElement != null) {
            if (ETagHelper.isETagHeaderInRequest(request)) {
                update = (Update)CqnUtils.modifiedWhere((CqnStatement)update, (Function)CqnUtils.andPredicate((CqnPredicate)ETagHelper.getETagPredicate(request, etagElement)));
            } else {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, new Object[0]);
            }
        }
        Result updateResult = CdsProcessor.draftEvent(update.ref(), cdsEntity, model) ? ((DraftService)cdsService).patchDraft((CqnUpdate)update, new Object[0]) : cdsService.run((CqnUpdate)update, new Object[0]);
        long rowCount = updateResult.rowCount();
        if (etagElement != null) {
            boolean ifNoneMatchAsterisk = ETagHelper.hasIfNoneMatchHeaderWithAsteriskValue(request);
            if (rowCount == 0L && !ifNoneMatchAsterisk || rowCount > 0L && ifNoneMatchAsterisk) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, new Object[0]);
            }
        }
        if (rowCount == 0L) {
            return this.post(request);
        }
        return new CdsODataResponse(204, null);
    }

    private static void defaultToNull(CdsEntity entity, Map<String, Object> data) {
        final ArrayList fkElements = new ArrayList();
        CqnVisitor visitor = new CqnVisitor(){

            public void visit(CqnElementRef elementRef) {
                String name;
                if (elementRef.segments().size() == 1 && !"$self".equals(name = elementRef.firstSegment())) {
                    fkElements.add(name);
                }
            }
        };
        entity.associations().map(e -> (CdsAssociationType)e.getType().as(CdsAssociationType.class)).map(a -> a.onCondition()).filter(o -> o.isPresent()).map(o -> (CqnPredicate)o.get()).forEach(p -> p.accept(visitor));
        entity.elements().filter(e -> !e.isKey()).filter(e -> !e.getType().isAssociation()).filter(e -> CdsAnnotations.ODATA_FOREIGN_KEY_FOR.getOrDefault((CdsAnnotatable)e) == null).filter(e -> !fkElements.contains(e.getName())).forEach(e -> data.putIfAbsent(e.getName(), null));
    }

    private static boolean draftEvent(CqnStructuredTypeRef ref, CdsEntity entity, CdsModel model) {
        Map targetKeys = CqnAnalyzer.create((CdsModel)model).analyze(ref).targetKeys();
        return DraftUtils.isDraftEnabled((CdsEntity)entity) && targetKeys.containsKey("IsActiveEntity") && (Boolean)targetKeys.get("IsActiveEntity") == false;
    }

    private static StructuredType<?> toPathExpression(CdsODataRequest request, CdsModel model) throws EdmException {
        CdsEntity rootEntity = model.getEntity(request.getName());
        Map<String, Object> keys = CdsProcessor.getFilterKeys(request.getUriInfo().getKeyPredicates());
        StructuredType entity = CQL.entity((String)rootEntity.getQualifiedName()).matching(keys);
        for (NavigationSegment segment : request.getNavigationSegments()) {
            keys = CdsProcessor.getFilterKeys(segment.getKeyPredicates());
            entity = entity.to(segment.getNavigationProperty().getName()).matching(keys);
        }
        return entity;
    }

    private static Map<String, Object> getFilterKeys(List<KeyPredicate> keyPredicates) throws EdmException {
        HashMap<String, Object> keys = new HashMap<String, Object>();
        for (KeyPredicate key : keyPredicates) {
            String name = key.getProperty().getName();
            EdmType type = key.getProperty().getType();
            keys.put(name, TypeConverterUtils.convertToType(type, key.getLiteral()));
        }
        return keys;
    }
}

