/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandWriteCallback
implements OnWriteFeedContent,
OnWriteEntryContent {
    private URI baseUri;
    private static final Logger logger = LoggerFactory.getLogger(ExpandWriteCallback.class);

    public ExpandWriteCallback(URI baseUri) {
        this.baseUri = baseUri;
    }

    public WriteEntryCallbackResult retrieveEntryResult(WriteEntryCallbackContext context) throws ODataApplicationException {
        WriteEntryCallbackResult result = new WriteEntryCallbackResult();
        Map entry = context.getEntryData();
        EdmNavigationProperty navigationProperty = context.getNavigationProperty();
        try {
            Map inlinedEntry = (Map)entry.get(navigationProperty.getName());
            result.setEntryData(inlinedEntry);
            if (inlinedEntry != null) {
                result.setInlineProperties(this.getInlineEntityProviderProperties((WriteCallbackContext)context).build());
            } else {
                result.setInlineProperties(context.getCurrentWriteProperties());
            }
            return result;
        }
        catch (EdmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
        }
    }

    private EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder getInlineEntityProviderProperties(WriteCallbackContext context) {
        EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)this.baseUri);
        propertiesBuilder.callbacks(ExpandWriteCallback.getCallbacks(this.baseUri, context.getCurrentExpandSelectTreeNode()));
        propertiesBuilder.expandSelectTree(context.getCurrentExpandSelectTreeNode());
        return propertiesBuilder;
    }

    public WriteFeedCallbackResult retrieveFeedResult(WriteFeedCallbackContext context) throws ODataApplicationException {
        WriteFeedCallbackResult result = new WriteFeedCallbackResult();
        try {
            Map entry = context.getEntryData();
            EdmNavigationProperty navigationProperty = context.getNavigationProperty();
            List inlinedFeed = (List)entry.get(navigationProperty.getName());
            result.setFeedData(inlinedFeed);
            if (inlinedFeed != null) {
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder providerWritePropertiesBuilder = this.getInlineEntityProviderProperties((WriteCallbackContext)context);
                providerWritePropertiesBuilder.selfLink(context.getSelfLink());
                result.setInlineProperties(providerWritePropertiesBuilder.build());
            } else {
                result.setInlineProperties(context.getCurrentWriteProperties());
            }
            return result;
        }
        catch (EdmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
        }
    }

    public static <T> Map<String, ODataCallback> getCallbacks(URI baseUri, ExpandSelectTreeNode expandSelectTreeNode) {
        HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
        for (String navigationPropertyName : expandSelectTreeNode.getLinks().keySet()) {
            callbacks.put(navigationPropertyName, (ODataCallback)new ExpandWriteCallback(baseUri));
        }
        return callbacks;
    }
}

