/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.processors.CdsODataRequest;
import com.sap.cds.adapter.odata.v2.processors.CdsODataResponse;
import com.sap.cds.adapter.odata.v2.processors.CdsProcessor;
import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.apache.olingo.odata2.api.commons.InlineCount;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderReadProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.uri.UriInfo;

public class ODataProcessor {
    private static final int NONE = -1;
    private final CdsRequestGlobals globals;
    CdsProcessor cdsProcessor;

    public ODataProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.cdsProcessor = new CdsProcessor();
    }

    public CdsODataResponse read(ODataContext oDataContext, UriInfo entitySetUriInfo, String contentType) {
        return this.read(oDataContext, entitySetUriInfo, contentType, null);
    }

    public CdsODataResponse read(ODataContext oDataContext, UriInfo entitySetUriInfo, String contentType, EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder) {
        CdsODataRequest cdsRequest = new CdsODataRequest(oDataContext, entitySetUriInfo, contentType, this.globals);
        CdsODataResponse cdsResponse = this.cdsProcessor.get(cdsRequest);
        Result result = cdsResponse.getResult();
        if (null != propertiesBuilder) {
            ODataProcessor.setInlineCount(result, propertiesBuilder);
        }
        return new CdsODataResponse(cdsResponse.getStatusCode(), result, cdsResponse.getNextLinkInfo());
    }

    public CdsODataResponse create(ODataContext odataContext, UriInfo uriInfo, InputStream content, String requestContentType, String contentType, EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder) {
        try {
            CdsODataRequest cdsRequest = new CdsODataRequest(odataContext, uriInfo, contentType, this.globals);
            EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(false).build();
            ODataEntry entry = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)properties);
            propertiesBuilder.expandSelectTree(entry.getExpandSelectTree());
            cdsRequest.setBodyMap(TypeConverterUtils.entryToMap(entry));
            return this.cdsProcessor.post(cdsRequest);
        }
        catch (EntityProviderException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DESERIALIZER_FAILED, new Object[]{e});
        }
    }

    public CdsODataResponse update(ODataContext odataContext, UriInfo uriInfo, InputStream content, String requestContentType, boolean merge, String contentType, EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder) {
        try {
            CdsODataRequest cdsRequest = new CdsODataRequest(odataContext, uriInfo, contentType, this.globals);
            EntityProviderReadProperties properties = EntityProviderReadProperties.init().mergeSemantic(merge).build();
            ODataEntry entry = EntityProvider.readEntry((String)requestContentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), (InputStream)content, (EntityProviderReadProperties)properties);
            propertiesBuilder.expandSelectTree(entry.getExpandSelectTree());
            cdsRequest.setBodyMap(TypeConverterUtils.entryToMap(entry));
            return this.cdsProcessor.put(cdsRequest);
        }
        catch (EntityProviderException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.DESERIALIZER_FAILED, new Object[]{e});
        }
    }

    public CdsODataResponse delete(ODataContext oDataContext, UriInfo uriInfo, String contentType) {
        CdsODataRequest cdsRequest = new CdsODataRequest(oDataContext, uriInfo, contentType, this.globals);
        return this.cdsProcessor.delete(cdsRequest);
    }

    public static Map<String, Object> toEntry(CdsODataResponse response) {
        return TypeConverterUtils.rowToMap(response.getResult().first());
    }

    public static List<Map<String, Object>> toFeed(CdsODataResponse response) {
        return TypeConverterUtils.resultToMap(response.getResult());
    }

    public static String toText(CdsODataResponse response) {
        return TypeConverterUtils.resultToString(response.getResult());
    }

    public static Object toSingleValue(CdsODataResponse response) {
        return TypeConverterUtils.rowToSingleValue(response.getResult().first());
    }

    private static void setInlineCount(Result result, EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder) {
        long inlineCount = result.inlineCount();
        if (inlineCount != -1L) {
            propertiesBuilder.inlineCount(Integer.valueOf((int)inlineCount));
            propertiesBuilder.inlineCountType(InlineCount.ALLPAGES);
        }
    }
}

