/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.EdmxReference;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.processors.CdsODataResponse;
import com.sap.cds.adapter.odata.v2.processors.ExpandWriteCallback;
import com.sap.cds.adapter.odata.v2.processors.ODataProcessor;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.adapter.odata.v2.utils.UriInfoUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.changeset.ChangeSetContext;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.batch.BatchHandler;
import org.apache.olingo.odata2.api.batch.BatchRequestPart;
import org.apache.olingo.odata2.api.batch.BatchResponsePart;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmServiceMetadata;
import org.apache.olingo.odata2.api.edm.provider.DataServices;
import org.apache.olingo.odata2.api.edm.provider.EdmProviderAccessor;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderBatchProperties;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.apache.olingo.odata2.api.processor.ODataContext;
import org.apache.olingo.odata2.api.processor.ODataRequest;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.apache.olingo.odata2.api.processor.ODataSingleProcessor;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.apache.olingo.odata2.api.uri.PathInfo;
import org.apache.olingo.odata2.api.uri.UriInfo;
import org.apache.olingo.odata2.api.uri.UriParser;
import org.apache.olingo.odata2.api.uri.info.DeleteUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetComplexPropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetCountUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntitySetUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetEntityUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetMetadataUriInfo;
import org.apache.olingo.odata2.api.uri.info.GetSimplePropertyUriInfo;
import org.apache.olingo.odata2.api.uri.info.PostUriInfo;
import org.apache.olingo.odata2.api.uri.info.PutMergePatchUriInfo;
import org.apache.olingo.odata2.core.ODataRequestImpl;
import org.apache.olingo.odata2.core.ODataResponseImpl;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.Encoder;
import org.apache.olingo.odata2.core.ep.BasicEntityProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OlingoProcessor
extends ODataSingleProcessor {
    private static final Logger logger = LoggerFactory.getLogger(OlingoProcessor.class);
    private final ODataProcessor odataProcessor;
    public static final String PREFIX_SAP = "sap";
    public static final String NAMESPACE_SAP = "http://www.sap.com/Protocols/SAPData";
    private CdsRequestGlobals globals;

    public OlingoProcessor(CdsRequestGlobals globals) {
        this.globals = globals;
        this.odataProcessor = new ODataProcessor(globals);
    }

    public ODataResponse readEntity(GetEntityUriInfo uriInfo, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                EntityProviderWriteProperties writeProperties = this.getPropertiesBuilder(this.getContext(), (UriInfo)uriInfo).build();
                CdsODataResponse response = this.odataProcessor.read(this.getContext(), (UriInfo)uriInfo, contentType);
                if (response.getStatusCode() == 304) {
                    ODataResponse.ODataResponseBuilder responseBuilder = ODataResponse.status((HttpStatusCodes)HttpStatusCodes.NOT_MODIFIED);
                    return responseBuilder.build();
                }
                return EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), ODataProcessor.toEntry(response), (EntityProviderWriteProperties)writeProperties);
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readEntitySet(GetEntitySetUriInfo uriInfo, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = this.getPropertiesBuilder(this.getContext(), (UriInfo)uriInfo);
                CdsODataResponse response = this.odataProcessor.read(this.getContext(), (UriInfo)uriInfo, contentType, propertiesBuilder);
                NextLinkInfo nextLinkInfo = response.getNextLinkInfo();
                if (nextLinkInfo != null && response.getResult().rowCount() >= (long)nextLinkInfo.getPageSize()) {
                    String nextLink = this.getSkipToken(uriInfo, nextLinkInfo);
                    propertiesBuilder.nextLink(nextLink);
                }
                return EntityProvider.writeFeed((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), ODataProcessor.toFeed(response), (EntityProviderWriteProperties)propertiesBuilder.build());
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    private String getSkipToken(GetEntitySetUriInfo uriInfo, NextLinkInfo nextLinkInfo) throws ODataException {
        String skiptoken = "$skiptoken";
        String odataPath = this.getContext().getPathInfo().getODataSegments().stream().map(e -> e.getPath()).collect(Collectors.joining("/"));
        Map query = ((ODataRequestImpl)this.getContext().getParameter("~odataRequest")).getQueryParameters();
        String filteredQuery = query.entrySet().stream().map(e -> (String)e.getKey() + "=" + Encoder.encode((String)((String)e.getValue()))).filter(q -> !q.startsWith("$skiptoken")).collect(Collectors.joining("&"));
        String skiptokenQuery = "$skiptoken=" + nextLinkInfo.getNextSkipToken();
        String fullQuery = StringUtils.isEmpty((String)filteredQuery) ? skiptokenQuery : filteredQuery + "&" + skiptokenQuery;
        return odataPath + "?" + fullQuery;
    }

    public ODataResponse countEntitySet(GetEntitySetCountUriInfo uriInfo, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                CdsODataResponse response = this.odataProcessor.read(this.getContext(), (UriInfo)uriInfo, contentType);
                return EntityProvider.writeText((String)ODataProcessor.toText(response));
            }
            catch (EntityProviderException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readEntitySimpleProperty(GetSimplePropertyUriInfo uriInfo, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                CdsODataResponse response = this.odataProcessor.read(this.getContext(), (UriInfo)uriInfo, contentType);
                return EntityProvider.writeProperty((String)contentType, (EdmProperty)UriInfoUtils.getSimpleProperty((UriInfo)uriInfo), (Object)ODataProcessor.toSingleValue(response));
            }
            catch (EntityProviderException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readEntitySimplePropertyValue(GetSimplePropertyUriInfo uriInfo, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                CdsODataResponse response = this.odataProcessor.read(this.getContext(), (UriInfo)uriInfo, contentType);
                return EntityProvider.writeText((String)ODataProcessor.toText(response));
            }
            catch (EntityProviderException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse deleteEntity(DeleteUriInfo uriInfo, String contentType) throws ODataException {
        return this.runInChangeSetContext(() -> {
            this.odataProcessor.delete(this.getContext(), (UriInfo)uriInfo, contentType);
            return ODataResponse.status((HttpStatusCodes)HttpStatusCodes.NO_CONTENT).build();
        });
    }

    public ODataResponse createEntity(PostUriInfo uriInfo, InputStream content, String requestContentType, String contentType) {
        return this.runInChangeSetContext(() -> {
            try {
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
                CdsODataResponse response = this.odataProcessor.create(this.getContext(), (UriInfo)uriInfo, content, requestContentType, contentType, propertiesBuilder);
                ExpandSelectTreeNode expandSelectTree = propertiesBuilder.build().getExpandSelectTree();
                HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
                if (!expandSelectTree.getLinks().isEmpty()) {
                    Map<String, ODataCallback> expandCallbacks = ExpandWriteCallback.getCallbacks(serviceRoot, expandSelectTree);
                    callbacks.putAll(expandCallbacks);
                }
                propertiesBuilder.callbacks(callbacks).isDataBasedPropertySerialization(true).expandSelectTree(expandSelectTree);
                return EntityProvider.writeEntry((String)contentType, (EdmEntitySet)uriInfo.getTargetEntitySet(), ODataProcessor.toEntry(response), (EntityProviderWriteProperties)propertiesBuilder.build());
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse updateEntity(PutMergePatchUriInfo uriInfo, InputStream content, String requestContentType, boolean merge, String contentType) throws ODataException {
        return this.runInChangeSetContext(() -> {
            try {
                URI serviceRoot = this.getContext().getPathInfo().getServiceRoot();
                EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder propertiesBuilder = EntityProviderWriteProperties.serviceRoot((URI)serviceRoot);
                this.odataProcessor.update(this.getContext(), (UriInfo)uriInfo, content, requestContentType, merge, contentType, propertiesBuilder);
                return ODataResponse.status((HttpStatusCodes)HttpStatusCodes.NO_CONTENT).build();
            }
            catch (ODataException e) {
                throw new ServiceException((Throwable)e);
            }
        });
    }

    public ODataResponse readEntityComplexProperty(GetComplexPropertyUriInfo uriInfo, String contentType) throws ODataException {
        return null;
    }

    public ODataResponse readMetadata(GetMetadataUriInfo uriInfo, String contentType) throws ODataException {
        HashMap<String, String> predefinedNamespaces = new HashMap<String, String>();
        predefinedNamespaces.put(PREFIX_SAP, NAMESPACE_SAP);
        EdmServiceMetadata edmServiceMetadata = this.getContext().getService().getEntityDataModel().getServiceMetadata();
        EdmProviderAccessor accessor = (EdmProviderAccessor)this.getContext().getService().getEntityDataModel();
        DataServices serviceMetadata = new DataServices();
        serviceMetadata.setDataServiceVersion(edmServiceMetadata.getDataServiceVersion());
        serviceMetadata.setSchemas(accessor.getEdmProvider().getSchemas());
        Map<Integer, EdmxReference> edmxReferences = ((ODataV2EdmProvider)accessor.getEdmProvider()).getEdmxReferencesMap();
        if (!edmxReferences.isEmpty()) {
            serviceMetadata.setAnnotationElements(((ODataV2EdmProvider)accessor.getEdmProvider()).generateAnnotationElement(edmxReferences).getAnnotationElements());
        }
        BasicEntityProvider basicEntityProvider = new BasicEntityProvider();
        ODataResponse odataResponse = basicEntityProvider.writeMetadata(serviceMetadata, predefinedNamespaces);
        ODataResponse.ODataResponseBuilder responseBuilder = ODataResponse.fromResponse((ODataResponse)odataResponse);
        return responseBuilder.build();
    }

    public ODataResponse executeBatch(BatchHandler handler, String contentType, InputStream content) throws ODataException {
        ArrayList<BatchResponsePart> batchResponseParts = new ArrayList<BatchResponsePart>();
        PathInfo pathInfo = this.getContext().getPathInfo();
        EntityProviderBatchProperties batchProperties = EntityProviderBatchProperties.init().pathInfo(pathInfo).build();
        List batchParts = EntityProvider.parseBatchRequest((String)contentType, (InputStream)content, (EntityProviderBatchProperties)batchProperties);
        for (BatchRequestPart batchPart : batchParts) {
            batchResponseParts.add(handler.handleBatchPart(batchPart));
        }
        ODataResponse batchResponse = EntityProvider.writeBatchResponse(batchResponseParts);
        return batchResponse;
    }

    public BatchResponsePart executeChangeSet(BatchHandler handler, List<ODataRequest> requests) throws ODataException {
        ArrayList responses = new ArrayList();
        return (BatchResponsePart)this.globals.getRuntime().changeSetContext().run(context -> {
            for (ODataRequest request : requests) {
                try {
                    ODataResponse response = handler.handleRequest(request);
                    responses.add(response);
                }
                catch (Throwable e) {
                    context.markForCancel();
                    logger.error("An unexpected error occurred during changeset processing", e);
                    ODataResponse.ODataResponseBuilder builder = ODataResponseImpl.newBuilder();
                    builder.status(HttpStatusCodes.fromStatusCode((int)500));
                    String message = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]).getLocalizedMessage(CdsRequestGlobals.current().getLocale());
                    String responseContent = "{\"error\":{\"code\":\"500\",\"message\":\"" + message + "\"}}";
                    builder.entity((Object)responseContent);
                    builder.header("Content-Type", ContentType.APPLICATION_JSON.toContentTypeString());
                    responses.add(builder.build());
                    return BatchResponsePart.responses((List)responses).changeSet(true).build();
                }
            }
            return BatchResponsePart.responses((List)responses).changeSet(true).build();
        });
    }

    private EntityProviderWriteProperties.ODataEntityProviderPropertiesBuilder getPropertiesBuilder(ODataContext oDataContext, UriInfo uriInfo) throws ODataException {
        URI serviceRoot = oDataContext.getPathInfo().getServiceRoot();
        ExpandSelectTreeNode expandSelectTree = UriParser.createExpandSelectTree((List)uriInfo.getSelect(), (List)uriInfo.getExpand());
        HashMap<String, ODataCallback> callbacks = new HashMap<String, ODataCallback>();
        if (!uriInfo.getExpand().isEmpty()) {
            Map<String, ODataCallback> expandCallbacks = ExpandWriteCallback.getCallbacks(serviceRoot, expandSelectTree);
            callbacks.putAll(expandCallbacks);
        }
        return EntityProviderWriteProperties.serviceRoot((URI)serviceRoot).expandSelectTree(expandSelectTree).callbacks(callbacks);
    }

    private ODataResponse runInChangeSetContext(Supplier<ODataResponse> supplier) {
        ChangeSetContext changeSetContext = ChangeSetContext.getCurrent();
        AtomicReference<ODataResponse> response = new AtomicReference<ODataResponse>();
        if (changeSetContext == null) {
            this.globals.getRuntime().changeSetContext().run(context -> response.set(this.run(supplier, (ChangeSetContext)context)));
        } else {
            response.set(this.run(supplier, changeSetContext));
        }
        return (ODataResponse)response.get();
    }

    private ODataResponse run(Supplier<ODataResponse> supplier, ChangeSetContext changeSetContext) {
        return (ODataResponse)this.globals.getRuntime().requestContext().run(requestContext -> {
            try {
                return (ODataResponse)supplier.get();
            }
            catch (Throwable e) {
                changeSetContext.markForCancel();
                logger.error(e.getMessage(), e);
                throw e;
            }
        });
    }
}

