/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.query;

import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Literal;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.NotImplementedException;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.edm.EdmNull;

public class ExpressionToCqnVisitor
implements ExpressionVisitor {
    private static final String NULL_KEYWORD = "null";

    public Object visitBinary(BinaryExpression binaryExpression, BinaryOperator operator, Object left, Object right) {
        switch (operator) {
            case AND: {
                return ((Predicate)left).and((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
            }
            case OR: {
                return ((Predicate)left).or((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
            }
            case EQ: {
                if (left == null && right != null) {
                    return ((Value)right).isNull();
                }
                if (right == null && left != null) {
                    return ((Value)left).isNull();
                }
                if (left != null) {
                    return ((Value)left).eq(right);
                }
                return CQL.literal((Object)true).eq((Object)true);
            }
            case NE: {
                if (left == null && right != null) {
                    return ((Value)right).isNotNull();
                }
                if (right == null && left != null) {
                    return ((Value)left).isNotNull();
                }
                if (left != null) {
                    return ((Value)left).ne(right);
                }
                return CQL.literal((Object)true).eq((Object)false);
            }
            case GE: {
                return ((Value)left).ge(right);
            }
            case GT: {
                return ((Value)left).gt(right);
            }
            case LE: {
                return ((Value)left).le(right);
            }
            case LT: {
                return ((Value)left).lt(right);
            }
            case ADD: {
                return ((Value)left).plus((Value)right);
            }
            case SUB: {
                return ((Value)left).minus((Value)right);
            }
            case MUL: {
                return ((Value)left).times((Value)right);
            }
            case DIV: {
                return ((Value)left).dividedBy((Value)right);
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_OPERATOR, new Object[]{operator});
    }

    public Object visitUnary(UnaryExpression unaryExpression, UnaryOperator operator, Object operand) {
        switch (operator) {
            case NOT: {
                return ((Predicate)operand).not();
            }
        }
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public Object visitMethod(MethodExpression methodExpression, MethodOperator methodCall, List<Object> parameters) {
        String func;
        Value value = (Value)parameters.get(0);
        switch (func = methodCall.name().toUpperCase(Locale.US)) {
            case "TOUPPER": {
                return value.toUpper();
            }
            case "TOLOWER": {
                return value.toLower();
            }
            case "LENGTH": 
            case "TRIM": {
                return CQL.func((String)methodCall.name(), (CqnValue[])new CqnValue[]{value});
            }
            case "SUBSTRING": {
                Value start = null;
                if (parameters.size() >= 2) {
                    start = (Value)parameters.get(1);
                }
                switch (parameters.size()) {
                    case 2: {
                        return value.substring(start);
                    }
                    case 3: {
                        Value length = (Value)parameters.get(2);
                        return value.substring(start, length);
                    }
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SUBSTRING, new Object[0]);
            }
            case "CONTAINS": {
                Value substring = (Value)parameters.get(1);
                return value.contains(substring);
            }
            case "STARTSWITH": {
                Value prefix = (Value)parameters.get(1);
                return value.startsWith(prefix);
            }
            case "ENDSWITH": {
                Value suffix = (Value)parameters.get(1);
                return value.endsWith(suffix);
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_METHOD, new Object[]{func});
    }

    public Literal<?> visitLiteral(LiteralExpression literal, EdmLiteral edmLiteral) {
        if (NULL_KEYWORD.equals(edmLiteral.getLiteral()) || edmLiteral.getType() instanceof EdmNull) {
            return null;
        }
        Object literalValue = TypeConverterUtils.convertToType((EdmType)edmLiteral.getType(), edmLiteral.getLiteral());
        return CQL.literal((Object)literalValue);
    }

    public ElementRef<?> visitMember(MemberExpression member, Object path, Object property) {
        throw new NotImplementedException("Not yet implemented");
    }

    public Object visitFilterExpression(FilterExpression filterExpression, String expressionString, Object expression) {
        throw new NotImplementedException("Not yet implemented");
    }

    public Object visitOrderByExpression(OrderByExpression orderByExpression, String expressionString, List<Object> orders) {
        throw new NotImplementedException("Not yet implemented");
    }

    public Object visitOrder(OrderExpression orderExpression, Object filterResult, SortOrder sortOrder) {
        throw new NotImplementedException("Not yet implemented");
    }

    public ElementRef<?> visitProperty(PropertyExpression propertyExpression, String uriLiteral, EdmTyped edmProperty) {
        return ElementRefImpl.element((String[])new String[]{uriLiteral});
    }
}

