/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.adapter.odata.v2.processors.CdsODataRequest;
import com.sap.cds.impl.builder.model.Conjunction;
import com.sap.cds.impl.builder.model.ElementRefImpl;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.CdsDataException;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.reflect.CdsAnnotatable;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsElement;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.reflect.CdsSimpleType;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ETagUtils;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.model.CdsAnnotations;
import com.sap.cds.util.CdsTypeUtils;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class ETagHelper {
    public static CdsElement getETagElement(String entityName, CdsModel cdsModel) {
        Optional entity = cdsModel.findEntity(entityName);
        if (entity.isPresent()) {
            return ETagHelper.getETagElement((CdsEntity)entity.get());
        }
        return null;
    }

    public static CdsElement getETagElement(CdsEntity entity) {
        return entity.elements().filter(e -> (Boolean)CdsAnnotations.ETAG.getOrDefault((CdsAnnotatable)e)).findFirst().orElse(null);
    }

    public static boolean isETagHeaderInRequest(CdsODataRequest odataRequest) {
        return odataRequest.getHeader("If-Match") != null || odataRequest.getHeader("If-None-Match") != null;
    }

    public static boolean hasIfNoneMatchHeaderWithAsteriskValue(CdsODataRequest request) {
        List headerValueList = ETagUtils.parseHeader((String)request.getHeader("If-None-Match"));
        return headerValueList != null && headerValueList.contains("*");
    }

    public static CqnPredicate getETagPredicate(CdsODataRequest request, CdsElement etagElement) {
        List ifNoneMatchValues;
        Predicate predicate = null;
        List ifMatchValues = ETagUtils.parseHeader((String)request.getHeader("If-Match"));
        if (ifMatchValues != null && !ifMatchValues.contains("*")) {
            List convertedValues = ifMatchValues.stream().map(v -> ETagHelper.convertETag(v, etagElement)).collect(Collectors.toList());
            predicate = ElementRefImpl.element((String[])new String[]{etagElement.getName()}).in(convertedValues);
        }
        if ((ifNoneMatchValues = ETagUtils.parseHeader((String)request.getHeader("If-None-Match"))) != null) {
            ifNoneMatchValues.remove("*");
            if (!ifNoneMatchValues.isEmpty()) {
                List convertedValues = ifNoneMatchValues.stream().map(v -> ETagHelper.convertETag(v, etagElement)).collect(Collectors.toList());
                Predicate predicateIfNone = CQL.not((CqnPredicate)ElementRefImpl.element((String[])new String[]{etagElement.getName()}).in(convertedValues));
                if (predicate != null) {
                    predicate = Conjunction.and((CqnPredicate)predicate, (CqnPredicate)predicateIfNone);
                } else {
                    return predicateIfNone;
                }
            }
        }
        return predicate;
    }

    private static Object convertETag(String value, CdsElement element) {
        CdsBaseType type = ((CdsSimpleType)element.getType().as(CdsSimpleType.class)).getType();
        try {
            return CdsTypeUtils.parse((CdsBaseType)type, (String)value);
        }
        catch (CdsDataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.ETAG_VALUE_INVALID, new Object[]{value, type.cdsName(), e});
        }
    }
}

