/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.reflect.CdsBaseType;
import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.util.CdsTypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.ep.entry.ODataEntry;
import org.apache.olingo.odata2.api.ep.feed.ODataFeed;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TypeConverterUtils {
    private static final Logger logger = LoggerFactory.getLogger(TypeConverterUtils.class);

    public static Object convertToType(EdmType type, String value) {
        Object typedValue;
        if (value == null) {
            return null;
        }
        switch (type.toString()) {
            case "Edm.Decimal": {
                typedValue = new BigDecimal(value);
                break;
            }
            case "Edm.Double": {
                typedValue = Double.parseDouble(value);
                break;
            }
            case "Edm.Single": {
                typedValue = Float.valueOf(Float.parseFloat(value));
                break;
            }
            case "Edm.Int64": {
                typedValue = Long.parseLong(value);
                break;
            }
            case "Edm.Int32": 
            case "Edm.Int16": 
            case "System.Uint7": 
            case "Edm.Byte": 
            case "Edm.SByte": {
                typedValue = Integer.parseInt(value);
                break;
            }
            case "Edm.Binary": {
                typedValue = value.getBytes(Charset.defaultCharset());
                break;
            }
            case "Edm.String": {
                if (value.length() >= 2 && value.startsWith("'") && value.endsWith("'")) {
                    typedValue = value.substring(1, value.length() - 1);
                    break;
                }
                typedValue = value;
                break;
            }
            case "Edm.TimeOfDay": {
                typedValue = LocalTime.parse(value);
                break;
            }
            case "Edm.Date": {
                typedValue = LocalDate.parse(value);
                break;
            }
            case "Edm.DateTimeOffset": {
                typedValue = ZonedDateTime.parse(value).toInstant();
                break;
            }
            case "Edm.Boolean": {
                typedValue = Boolean.parseBoolean(value);
                break;
            }
            case "Edm.Guid": {
                typedValue = CdsTypeUtils.parseUuid((Object)value);
                break;
            }
            default: {
                typedValue = value;
            }
        }
        return typedValue;
    }

    public static Result convertResultTypes(CdsEntity cdsEntity, Iterable<Row> result) {
        result.forEach(row -> TypeConverterUtils.convertResultTypes(cdsEntity, (Map<String, Object>)row));
        return (Result)result;
    }

    private static Map<String, Object> convertResultTypes(CdsEntity cdsEntity, Map<String, Object> result) {
        List uuids = cdsEntity.elements().filter(p -> p.getType().isSimpleType(CdsBaseType.UUID)).collect(Collectors.toList());
        List dateTimes = cdsEntity.elements().filter(p -> p.getType().isSimpleType(CdsBaseType.TIMESTAMP)).collect(Collectors.toList());
        result.forEach((key, value) -> {
            uuids.forEach(uuid -> {
                if (key.equals(uuid.getName()) && !(value instanceof UUID)) {
                    result.put(uuid.getName(), UUID.fromString((String)value));
                }
            });
            dateTimes.forEach(dt -> {
                if (key.equals(dt.getName())) {
                    result.put(dt.getName(), ((Instant)value).toEpochMilli());
                }
            });
            try {
                CdsEntity innerCdsEntity = cdsEntity.getTargetOf(key);
                if (value instanceof Map) {
                    TypeConverterUtils.convertResultTypes(innerCdsEntity, (Map)value);
                } else if (value instanceof List) {
                    TypeConverterUtils.convertResultTypes(innerCdsEntity, (Iterable)value);
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
        });
        return result;
    }

    public static Map<String, Object> convertRequestPayloadTypes(CdsEntity cdsEntity, Map<String, Object> payload) {
        List uuids = cdsEntity.elements().filter(p -> p.getType().isSimpleType(CdsBaseType.UUID)).collect(Collectors.toList());
        List dateTimes = cdsEntity.elements().filter(p -> p.getType().isSimpleType(CdsBaseType.TIMESTAMP)).collect(Collectors.toList());
        payload.forEach((key, value) -> {
            uuids.forEach(uuid -> {
                if (key.equals(uuid.getName())) {
                    payload.put(uuid.getName(), value.toString());
                }
            });
            dateTimes.forEach(dt -> {
                if (key.equals(dt.getName()) && value instanceof GregorianCalendar) {
                    payload.put(dt.getName(), ((GregorianCalendar)value).toZonedDateTime().toInstant());
                }
                if (key.equals(dt.getName()) && value instanceof Timestamp) {
                    payload.put(dt.getName(), ((Timestamp)value).toInstant());
                }
            });
            try {
                CdsEntity innerCdsEntity = cdsEntity.getTargetOf(key);
                if (value instanceof Map) {
                    TypeConverterUtils.convertRequestPayloadTypes(innerCdsEntity, (Map)value);
                } else if (value instanceof List) {
                    TypeConverterUtils.convertPayloadTypes(innerCdsEntity, (Iterable)value);
                }
            }
            catch (Exception e) {
                logger.debug(e.getMessage());
            }
        });
        return payload;
    }

    public static Result convertPayloadTypes(CdsEntity cdsEntity, Iterable<Row> payload) {
        payload.forEach(row -> TypeConverterUtils.convertResultTypes(cdsEntity, (Map<String, Object>)row));
        return (Result)payload;
    }

    public static List<Map<String, Object>> resultToMap(Result result) {
        return result.stream().collect(Collectors.toList());
    }

    public static Map<String, Object> rowToMap(Optional<Row> row) {
        if (row.isPresent()) {
            return (Map)row.get();
        }
        return Collections.emptyMap();
    }

    public static Object rowToSingleValue(Optional<Row> row) {
        if (row.isPresent()) {
            return TypeConverterUtils.findFirstValue((Map)row.get());
        }
        return null;
    }

    public static String resultToString(Result result) {
        return TypeConverterUtils.findFirstValue(TypeConverterUtils.rowToMap(result.first())).toString();
    }

    private static Object findFirstValue(Map<String, Object> row) {
        return row.values().stream().findFirst().get();
    }

    public static Map<String, Object> entryToMap(ODataEntry entry) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (Map.Entry property : entry.getProperties().entrySet()) {
            Object value = property.getValue();
            if (value instanceof ODataFeed) {
                value = TypeConverterUtils.feedToListOfMaps((ODataFeed)value);
            } else if (value instanceof ODataEntry) {
                value = TypeConverterUtils.entryToMap((ODataEntry)value);
            }
            result.put((String)property.getKey(), value);
        }
        return result;
    }

    private static List<Map<String, Object>> feedToListOfMaps(ODataFeed feed) {
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (ODataEntry feedEntry : feed.getEntries()) {
            result.add(TypeConverterUtils.entryToMap(feedEntry));
        }
        return result;
    }
}

