/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.v2;

import com.google.common.hash.Hashing;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.feature.mt.v2.EdmxProviderAccessor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.ByteArrayInputStream;
import org.apache.olingo.odata2.api.exception.ODataException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractEdmxProviderAccessor
implements EdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(AbstractEdmxProviderAccessor.class);
    protected static final String XML = ".xml";
    protected static final String EDMX_FILE_PATH = "edmx/";

    public abstract boolean isActiveFeature();

    public abstract String getFeatureName();

    protected abstract MetadataInfo getMetadataInfo(String var1);

    protected abstract void storeAlias(String var1, String var2);

    protected abstract void storeNameSpace(String var1, String var2);

    protected abstract String getAlias(String var1);

    protected abstract String getNameSpace(String var1);

    @Override
    public ODataV2EdmProvider getEdmxMetadataProvider(String serviceName) {
        String name = this.getServiceByNamespace(serviceName);
        if (name == null) {
            name = serviceName;
        }
        return this.getMetadataInfo(name).getEdmxMetadataProvider();
    }

    @Override
    public String getMetadataEtag(String serviceName) {
        String name = this.getServiceByNamespace(serviceName);
        if (name == null) {
            name = serviceName;
        }
        return this.getMetadataInfo(name).getEtag();
    }

    public void registerSchemaAlias(String alias, String serviceName) {
        if (alias != null) {
            this.storeAlias(alias, serviceName);
        }
    }

    public void registerSchemaNamespace(String namespace, String serviceName) {
        if (namespace != null) {
            this.storeNameSpace(namespace, serviceName);
        }
    }

    public String getServiceByNamespace(String namespace) {
        String alias = this.getAlias(namespace);
        if (alias != null) {
            return alias;
        }
        return this.getNameSpace(namespace);
    }

    protected ODataV2EdmProvider loadMetadataFiles(String serviceName, byte[] edmxBytes) {
        String edmxFileName = EDMX_FILE_PATH + serviceName + XML;
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        ODataV2EdmProvider edmxProvider = null;
        log.info("Loading OData metadata file '{}'", (Object)edmxFileName);
        try {
            edmxProvider = new ODataV2EdmProvider(new ByteArrayInputStream(edmxBytes));
            this.storeAliasNamespace(edmxProvider, serviceName);
        }
        catch (ODataException e) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{edmxFileName, e});
        }
        return edmxProvider;
    }

    protected String calculateMetadataEtag(byte[] edmxBytes) {
        if (edmxBytes == null || edmxBytes.length == 0) {
            return null;
        }
        return Hashing.sha256().hashBytes(edmxBytes).toString();
    }

    private void storeAliasNamespace(ODataV2EdmProvider edmxMetadataProvider, String serviceName) throws ODataException {
        edmxMetadataProvider.getSchemas().forEach(schema -> {
            this.registerSchemaNamespace(schema.getNamespace(), serviceName);
            this.registerSchemaAlias(schema.getAlias(), serviceName);
        });
    }
}

