/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.v2;

import com.google.common.io.ByteStreams;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.feature.mt.v2.AbstractEdmxProviderAccessor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(DefaultEdmxProviderAccessor.class);
    private static final String EDMX_FILE_PATH = "edmx/";
    private Map<String, MetadataInfo> metadataInfoMap = new ConcurrentHashMap<String, MetadataInfo>();
    private Map<String, String> aliasMap = new ConcurrentHashMap<String, String>();
    private Map<String, String> namespaceMap = new ConcurrentHashMap<String, String>();

    @Override
    public boolean isActiveFeature() {
        return true;
    }

    @Override
    public String getFeatureName() {
        return "Default EDMX Provider";
    }

    private InputStream getEdmxFileStream(String serviceName) {
        String edmxFileName = EDMX_FILE_PATH + serviceName + ".xml";
        return this.getClass().getClassLoader().getResourceAsStream(edmxFileName);
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        return this.metadataInfoMap.computeIfAbsent(serviceName, key -> {
            ODataV2EdmProvider provider = null;
            String etag = null;
            InputStream edmxStream = this.getEdmxFileStream(serviceName);
            if (edmxStream != null) {
                try {
                    byte[] edmxBytes = ByteStreams.toByteArray((InputStream)edmxStream);
                    provider = this.loadMetadataFiles(serviceName, edmxBytes);
                    etag = this.calculateMetadataEtag(edmxBytes);
                }
                catch (IOException e) {
                    String edmxFileName = EDMX_FILE_PATH + serviceName + ".xml";
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA, new Object[]{edmxFileName, e});
                }
                finally {
                    try {
                        edmxStream.close();
                    }
                    catch (IOException e) {
                        log.warn("Failed to close edmx input stream", (Throwable)e);
                    }
                }
            }
            return new MetadataInfo(serviceName, serviceName, provider, etag);
        });
    }

    @Override
    protected void storeAlias(String key, String value) {
        this.aliasMap.put(key, value);
    }

    @Override
    protected void storeNameSpace(String key, String value) {
        this.namespaceMap.put(key, value);
    }

    @Override
    protected String getAlias(String key) {
        return this.aliasMap.get(key);
    }

    @Override
    protected String getNameSpace(String key) {
        return this.namespaceMap.get(key);
    }
}

