/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.feature.mt.v2;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.feature.mt.v2.AbstractEdmxProviderAccessor;
import com.sap.cds.mtx.MetaDataAccessor;
import com.sap.cds.mtx.impl.CacheParams;
import com.sap.cds.mtx.impl.MetaDataAccessorImpl;
import com.sap.cds.mtx.impl.SidecarAccess;
import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.utils.TenantAwareCache;
import com.sap.cds.services.utils.mtx.MtxUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MtxEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static Logger log = LoggerFactory.getLogger(MtxEdmxProviderAccessor.class);
    MetaDataAccessor<MetadataInfo> accessor;
    private final TenantAwareCache<Map<String, String>, CdsModel> aliasCache;
    private final TenantAwareCache<Map<String, String>, CdsModel> namespaceCache;
    private final TenantAwareCache<Set<String>, CdsModel> unresolvedCache;

    public MtxEdmxProviderAccessor() {
        Supplier<String> tenant = CdsRequestGlobals::currentTenant;
        Supplier<CdsModel> model = CdsRequestGlobals::currentModel;
        this.aliasCache = TenantAwareCache.create(tenant, () -> new ConcurrentHashMap(), model);
        this.namespaceCache = TenantAwareCache.create(tenant, () -> new ConcurrentHashMap(), model);
        this.unresolvedCache = TenantAwareCache.create(tenant, () -> ConcurrentHashMap.newKeySet(), model);
    }

    @Override
    public boolean isActiveFeature() {
        SidecarAccess access = MtxUtils.getSidecarAccess();
        if (access == null) {
            return false;
        }
        CacheParams cacheParams = MtxUtils.getCacheParams();
        this.accessor = new MetaDataAccessorImpl(access, cacheParams, (edmx, service) -> {
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            ODataV2EdmProvider edmProvider = this.loadMetadataFiles(service, edmxBytes);
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(service, service, edmProvider, etag);
        }, null);
        return true;
    }

    @Override
    public String getFeatureName() {
        return "MTX EDMX Provider";
    }

    @Override
    protected MetadataInfo getMetadataInfo(String serviceName) {
        MetadataInfo info;
        Locale locale = CdsRequestGlobals.current().getLocale();
        String localeString = locale != null ? locale.getLanguage() : Locale.ENGLISH.getLanguage();
        log.debug("Retrieving model for service name '{}' and locale '{}'", (Object)serviceName, (Object)(localeString != null ? localeString : "<none>"));
        if (((Set)this.unresolvedCache.findOrCreate()).contains(serviceName)) {
            info = new MetadataInfo(serviceName, serviceName, null, null);
        } else {
            String tenant = CdsRequestGlobals.currentTenant();
            try {
                info = (MetadataInfo)this.accessor.getEdmx(tenant, serviceName, localeString);
            }
            catch (Throwable t) {
                log.debug("Could not find edmx for service '{}'", (Object)serviceName, (Object)t);
                ((Set)this.unresolvedCache.findOrCreate()).add(serviceName);
                info = new MetadataInfo(serviceName, serviceName, null, null);
            }
        }
        return info;
    }

    @Override
    protected void storeAlias(String key, String value) {
        ((Map)this.aliasCache.findOrCreate()).put(key, value);
    }

    @Override
    protected void storeNameSpace(String key, String value) {
        ((Map)this.namespaceCache.findOrCreate()).put(key, value);
    }

    @Override
    protected String getAlias(String key) {
        return (String)((Map)this.aliasCache.findOrCreate()).get(key);
    }

    @Override
    protected String getNameSpace(String key) {
        return (String)((Map)this.namespaceCache.findOrCreate()).get(key);
    }
}

