/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.google.common.annotations.VisibleForTesting;
import com.sap.cds.adapter.odata.v2.utils.MessagesUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.application.ApplicationLifecycleService;
import com.sap.cds.services.application.ErrorResponseEventContext;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Collection;
import java.util.Locale;
import java.util.stream.Collectors;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.olingo.odata2.api.commons.HttpStatusCodes;
import org.apache.olingo.odata2.api.ep.EntityProvider;
import org.apache.olingo.odata2.api.ep.EntityProviderException;
import org.apache.olingo.odata2.api.exception.ODataPreconditionFailedException;
import org.apache.olingo.odata2.api.exception.ODataPreconditionRequiredException;
import org.apache.olingo.odata2.api.processor.ODataErrorCallback;
import org.apache.olingo.odata2.api.processor.ODataErrorContext;
import org.apache.olingo.odata2.api.processor.ODataResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorCallback
implements ODataErrorCallback {
    private static final Logger logger = LoggerFactory.getLogger(ErrorCallback.class);
    private final CdsRuntime runtime;

    public ErrorCallback(CdsRuntime runtime) {
        this.runtime = runtime;
    }

    public ODataResponse handleError(ODataErrorContext context) {
        ServiceException exception;
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        Locale locale = requestContext.getParameterInfo().getLocale();
        context.setLocale(locale == null ? Locale.ENGLISH : locale);
        context.setContentType(ErrorCallback.negotiateContentType(requestContext, context.getContentType()));
        if (context.getException() instanceof ServiceException) {
            exception = (ServiceException)context.getException();
        } else if (context.getException().getCause() instanceof EntityProviderException) {
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)context.getException().getCause());
            exception = new ServiceException((ErrorStatus)ErrorStatuses.BAD_REQUEST, rootCause.getMessage(), new Object[]{context.getException()});
        } else {
            exception = context.getException() instanceof ODataPreconditionRequiredException ? new ServiceException((ErrorStatus)CdsErrorStatuses.ETAG_REQUIRED, context.getMessage(), new Object[]{context.getException()}) : (context.getException() instanceof ODataPreconditionFailedException ? new ServiceException((ErrorStatus)CdsErrorStatuses.ETAG_FAILED, context.getMessage(), new Object[]{context.getException()}) : new ServiceException(ErrorCallback.toErrorStatus(context), context.getMessage(), new Object[]{context.getException()}));
        }
        ErrorCallback.handleWithApplicationEvent(requestContext, exception, context);
        int statusCode = context.getHttpStatus().getStatusCode();
        if (statusCode >= 500 && statusCode < 600) {
            logger.error(context.getMessage(), (Throwable)context.getException());
        } else {
            logger.debug(context.getMessage(), (Throwable)context.getException());
        }
        ODataResponse odataResponse = EntityProvider.writeErrorDocument((ODataErrorContext)context);
        return ODataResponse.fromResponse((ODataResponse)odataResponse).header("Content-Type", context.getContentType()).status(context.getHttpStatus()).build();
    }

    @VisibleForTesting
    static void handleWithApplicationEvent(RequestContext requestContext, ServiceException exception, ODataErrorContext errorContext) {
        ApplicationLifecycleService applicationLifecycleService = (ApplicationLifecycleService)requestContext.getServiceCatalog().getService(ApplicationLifecycleService.class, "ApplicationLifecycleService$Default");
        try {
            ErrorResponseEventContext.ErrorResponse response = applicationLifecycleService.errorResponse(exception);
            Message message = (Message)response.getMessages().get(0);
            errorContext.setHttpStatus(HttpStatusCodes.fromStatusCode((int)response.getHttpStatus()));
            errorContext.setErrorCode(message.getCode() != null ? message.getCode() : String.valueOf(response.getHttpStatus()));
            errorContext.setSeverity(ErrorCallback.toExternalSeverity(message));
            errorContext.setMessage(message.getMessage());
            errorContext.setTarget(MessagesUtils.getTarget(message.getTarget()));
            errorContext.setErrorDetails((Collection)response.getMessages().stream().skip(1L).map(m -> {
                ODataErrorContext detail = new ODataErrorContext();
                detail.setErrorCode(m.getCode());
                detail.setSeverity(ErrorCallback.toExternalSeverity(m));
                detail.setMessage(m.getMessage());
                detail.setTarget(MessagesUtils.getTarget(m.getTarget()));
                return detail;
            }).collect(Collectors.toList()));
        }
        catch (Exception e) {
            logger.error("Unexpected exception in error response handling", (Throwable)e);
            ErrorCallback.fallback(requestContext, errorContext);
        }
    }

    @VisibleForTesting
    static String negotiateContentType(RequestContext requestContext, String contentType) {
        if ("application/json".equals(contentType) || "application/json".equals(requestContext.getParameterInfo().getHeader("Accept")) || "json".equals(requestContext.getParameterInfo().getQueryParameter("format"))) {
            return "application/json";
        }
        return "application/xml";
    }

    private static ErrorStatus toErrorStatus(final ODataErrorContext context) {
        return new ErrorStatus(){

            public int getHttpStatus() {
                if (context.getHttpStatus() == null) {
                    return ErrorStatuses.SERVER_ERROR.getHttpStatus();
                }
                return context.getHttpStatus().getStatusCode();
            }

            public String getCodeString() {
                return context.getErrorCode();
            }
        };
    }

    private static void fallback(RequestContext requestContext, ODataErrorContext errorContext) {
        ErrorStatusException exp = new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[0]);
        errorContext.setErrorCode(exp.getErrorStatus().getCodeString());
        errorContext.setException((Exception)((Object)exp));
        errorContext.setSeverity(Message.Severity.ERROR.toString().toLowerCase(Locale.ENGLISH));
        errorContext.setHttpStatus(HttpStatusCodes.fromStatusCode((int)exp.getErrorStatus().getHttpStatus()));
        errorContext.setMessage(exp.getLocalizedMessage(requestContext.getParameterInfo().getLocale()));
    }

    private static String toExternalSeverity(Message m) {
        return m.getSeverity().toString().toLowerCase(Locale.ENGLISH);
    }
}

