/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2;

import java.util.HashMap;
import java.util.Map;

import com.sap.cds.reflect.CdsModel;
import com.sap.cds.services.cds.ApplicationService;
import com.sap.cds.services.runtime.CdsRuntime;

public class CdsRequestGlobals {

	private final CdsRuntime runtime;
	private final CdsModel model;
	private final Map<String, String> cdsEntityNames = new HashMap<>();

	private ApplicationService service;

	public CdsRequestGlobals(CdsRuntime runtime, CdsModel model) {
		this.runtime = runtime;
		this.model = model;
	}

	public CdsRuntime getRuntime() {
		return runtime;
	}

	public CdsModel getModel() {
		return model;
	}

	public Map<String, String> getCdsEntityNames() {
		return cdsEntityNames;
	}

	public ApplicationService getApplicationService() {
		return service;
	}

	public void setApplicationService(ApplicationService service) {
		this.service = service;
	}


}
