/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.metadata;

public class MetadataInfo {

	private final byte[] edmxBytes;
	private final ODataV2EdmProvider provider;
	private final String etag;

	public MetadataInfo(byte[] edmxBytes, ODataV2EdmProvider provider, String etag) {
		this.edmxBytes = edmxBytes;
		this.provider = provider;
		this.etag = etag;
	}

	public byte[] getEdmxBytes() {
		return edmxBytes;
	}

	public ODataV2EdmProvider getEdmxMetadataProvider() {
		return provider;
	}

	public String getEtag() {
		return etag;
	}
}
