/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.query;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import com.sap.cds.reflect.CdsEntity;
import com.sap.cds.reflect.CdsService;
import com.sap.cds.services.environment.CdsProperties.Query.Limit;
import com.sap.cds.services.utils.model.CdsAnnotations;

public class LimitLookup {

	private final Limit config;

	public LimitLookup(Limit config) {
		this.config = config;
	}

	private Map<String, Integer> defaultMap = new ConcurrentHashMap<>();
	private Map<String, Integer> maxMap = new ConcurrentHashMap<>();

	public int getDefaultValue(CdsService service, CdsEntity entity) {
		Integer currentValue = defaultMap.get(entity.getQualifiedName());
		if(currentValue == null) {
			currentValue = getDefaultValueInternal(service, entity);
			defaultMap.put(entity.getQualifiedName(), currentValue);
		}
		return currentValue;
	}

	private int getDefaultValueInternal(CdsService service, CdsEntity entity) {
		Object defaultEntity = CdsAnnotations.QUERY_LIMIT_DEFAULT.getOrDefault(entity);
		if(defaultEntity instanceof Integer integer) {
			return integer;
		}

		Object defaultService = CdsAnnotations.QUERY_LIMIT_DEFAULT.getOrDefault(service);
		if(defaultService instanceof Integer integer) {
			return integer;
		}

		return config.getDefault();
	}

	public int getMaxValue(CdsService service, CdsEntity entity) {
		Integer currentValue = maxMap.get(entity.getQualifiedName());
		if(currentValue == null) {
			currentValue = getMaxValueInternal(service, entity);
			maxMap.put(entity.getQualifiedName(), currentValue);
		}
		return currentValue;
	}

	private int getMaxValueInternal(CdsService service, CdsEntity entity) {
		Object maxEntity = CdsAnnotations.QUERY_LIMIT_MAX.getOrDefault(entity);
		if(maxEntity instanceof Integer integer) {
			return integer;
		}

		Object maxService = CdsAnnotations.QUERY_LIMIT_MAX.getOrDefault(service);
		if(maxService instanceof Integer integer) {
			return integer;
		}

		return config.getMax();
	}

}
