/**************************************************************************
 * (C) 2019-2024 SAP SE or an SAP affiliate company. All rights reserved. *
 **************************************************************************/
package com.sap.cds.adapter.odata.v2.utils;

import java.io.IOException;
import java.io.InputStream;

import org.apache.commons.io.input.ProxyInputStream;

public class CheckableInputStream extends ProxyInputStream {

	private boolean dataRead = false;

	public CheckableInputStream(InputStream proxy) {
		super(proxy);
	}

	@Override
	protected void afterRead(int n) throws IOException {
		if(n > 0) {
			dataRead = true;
		}
	}

	public boolean isDataRead() {
		return dataRead;
	}

}
