/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.edm.EdmEntitySet;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.ep.EntityProviderWriteProperties;
import org.apache.olingo.odata2.api.ep.callback.OnWriteEntryContent;
import org.apache.olingo.odata2.api.ep.callback.OnWriteFeedContent;
import org.apache.olingo.odata2.api.ep.callback.WriteCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteEntryCallbackResult;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackContext;
import org.apache.olingo.odata2.api.ep.callback.WriteFeedCallbackResult;
import org.apache.olingo.odata2.api.exception.ODataApplicationException;
import org.apache.olingo.odata2.api.uri.ExpandSelectTreeNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpandWriteCallback
implements OnWriteFeedContent,
OnWriteEntryContent {
    private URI baseUri;
    private boolean deferredExpand;
    private static final Logger logger = LoggerFactory.getLogger(ExpandWriteCallback.class);

    public ExpandWriteCallback(URI baseUri, boolean deferredExpand) {
        this.baseUri = baseUri;
        this.deferredExpand = deferredExpand;
    }

    public WriteEntryCallbackResult retrieveEntryResult(WriteEntryCallbackContext context) throws ODataApplicationException {
        WriteEntryCallbackResult result = new WriteEntryCallbackResult();
        Map entry = context.getEntryData();
        EdmNavigationProperty navigationProperty = context.getNavigationProperty();
        try {
            Map inlinedEntry = (Map)entry.get(navigationProperty.getName());
            result.setEntryData(inlinedEntry);
            if (inlinedEntry != null) {
                result.setInlineProperties(this.getInlineEntityProviderProperties((WriteCallbackContext)context, inlinedEntry));
            } else {
                result.setInlineProperties(context.getCurrentWriteProperties());
            }
            return result;
        }
        catch (EdmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
        }
    }

    private EntityProviderWriteProperties getInlineEntityProviderProperties(WriteCallbackContext context, Map<String, Object> propertyMap) throws EdmException {
        EntityProviderWriteProperties inlineProperties = null;
        EdmNavigationProperty navProperty = context.getNavigationProperty();
        EdmEntitySet sourceEntitySet = context.getSourceEntitySet();
        EdmEntitySet relatedEntitySet = sourceEntitySet.getRelatedEntitySet(navProperty);
        ArrayList<String> selectedProperties = new ArrayList<String>(propertyMap.keySet());
        ArrayList allNavigationProperties = new ArrayList(relatedEntitySet.getEntityType().getNavigationPropertyNames());
        List<Object> expandedNavigationProperties = allNavigationProperties;
        if (this.deferredExpand) {
            expandedNavigationProperties = allNavigationProperties.stream().filter(e -> selectedProperties.contains(e)).collect(Collectors.toList());
        }
        selectedProperties.removeAll(allNavigationProperties);
        ExpandSelectTreeNode expandSelectTree = null;
        ArrayList properties = new ArrayList();
        properties.addAll(relatedEntitySet.getEntityType().getPropertyNames());
        properties.retainAll(propertyMap.keySet());
        HashMap<String, ExpandWriteCallback> callbacks = new HashMap<String, ExpandWriteCallback>();
        if (expandedNavigationProperties.size() > 0) {
            for (String string : expandedNavigationProperties) {
                callbacks.put(string, new ExpandWriteCallback(this.baseUri, this.deferredExpand));
            }
        }
        expandSelectTree = ExpandSelectTreeNode.entitySet((EdmEntitySet)relatedEntitySet).expandedLinks(allNavigationProperties).build();
        inlineProperties = EntityProviderWriteProperties.serviceRoot((URI)this.baseUri).expandSelectTree(expandSelectTree).callbacks(callbacks).build();
        return inlineProperties;
    }

    public WriteFeedCallbackResult retrieveFeedResult(WriteFeedCallbackContext context) throws ODataApplicationException {
        WriteFeedCallbackResult result = new WriteFeedCallbackResult();
        try {
            Map entry = context.getEntryData();
            EdmNavigationProperty navigationProperty = context.getNavigationProperty();
            List inlinedFeed = (List)entry.get(navigationProperty.getName());
            result.setFeedData(inlinedFeed);
            if (inlinedFeed != null && !inlinedFeed.isEmpty()) {
                result.setInlineProperties(this.getInlineEntityProviderProperties((WriteCallbackContext)context, (Map)inlinedFeed.get(0)));
            } else {
                result.setInlineProperties(context.getCurrentWriteProperties());
            }
            return result;
        }
        catch (EdmException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new ErrorStatusException((ErrorStatus)ErrorStatuses.SERVER_ERROR, new Object[]{e});
        }
    }
}

