/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.search;

import com.sap.cds.adapter.odata.v2.search.SearchQueryToken;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchTokenizer {
    private static final Logger logger = LoggerFactory.getLogger(SearchTokenizer.class);

    public List<SearchQueryToken> tokenize(String searchQuery) {
        if (searchQuery.contains("%28") || searchQuery.contains("%29") || searchQuery.contains("%22")) {
            logger.error("Invalid Token in Query string '");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }
        char[] chars = searchQuery.trim().toCharArray();
        State state = new SearchExpressionState();
        ArrayList<SearchQueryToken> states = new ArrayList<SearchQueryToken>();
        for (char aChar : chars) {
            State next = ((State)state).nextChar(aChar);
            if (state.isFinished()) {
                states.add(state);
            }
            state = next;
        }
        if (!state.close().isFinished()) {
            logger.error("Last parsed state '" + state.toString() + "' is not finished.");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }
        states.add(state);
        return states;
    }

    private class SearchExpressionState
    extends LiteralState {
        private SearchExpressionState() {
        }

        @Override
        public State nextChar(char c) {
            if (c == '(') {
                return new OpenState();
            }
            if (SearchExpressionState.isWhitespace(c)) {
                return new RwsState();
            }
            if (c == ')') {
                return new CloseState();
            }
            return new SearchTermState().init(c);
        }

        @Override
        public State init(char c) {
            return this.nextChar(c);
        }
    }

    private static abstract class State
    implements SearchQueryToken {
        private SearchQueryToken.Token token = null;
        private boolean finished = false;
        protected static final char QUOTATION_MARK = '\"';
        protected static final char PHRASE_ESCAPE_CHAR = '\\';
        protected static final char CHAR_N = 'N';
        protected static final char CHAR_O = 'O';
        protected static final char CHAR_T = 'T';
        protected static final char CHAR_A = 'A';
        protected static final char CHAR_D = 'D';
        protected static final char CHAR_R = 'R';
        protected static final char CHAR_CLOSE = ')';
        protected static final char CHAR_OPEN = '(';

        public State() {
        }

        public State(SearchQueryToken.Token t) {
            this.token = t;
        }

        public State(SearchQueryToken.Token t, boolean finished) {
            this(t);
            this.finished = finished;
        }

        protected abstract State nextChar(char var1);

        public State allowed(char c) {
            return this;
        }

        public State forbidden(char c) {
            logger.error("Forbidden character in state " + this.token + "->" + c);
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }

        public State invalid() {
            logger.error("Token " + this.token + " is in invalid state.");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }

        public State finish() {
            this.finished = true;
            return this;
        }

        public State finishAs(SearchQueryToken.Token token) {
            this.finished = true;
            return this.changeToken(token);
        }

        public boolean isFinished() {
            return this.finished;
        }

        @Override
        public SearchQueryToken.Token getToken() {
            return this.token;
        }

        public State close() {
            return this;
        }

        protected State changeToken(SearchQueryToken.Token token) {
            this.token = token;
            return this;
        }

        static boolean isAllowedWord(char character) {
            return Character.isUnicodeIdentifierStart(character) || State.isUnreserved(character) || State.isOtherDelimsForWord(character);
        }

        static boolean isAllowedPhrase(char character) {
            return character != '\"';
        }

        private static boolean isOtherDelimsForWord(char character) {
            return character == '!' || character == '*' || character == '+' || character == ':' || character == '@' || character == '/' || character == '\\' || character == '?' || character == '$' || character == '=' || character == '%' || character == '\'' || character == '&' || character == '{' || character == '}' || character == '[' || character == ']' || character == ',' || character == '#' || character == '^' || character == '|' || character == '>' || character == '<' || character == '`' || character == ';';
        }

        private static boolean isUnreserved(char character) {
            return State.isAlphaOrDigit(character) || character == '-' || character == '.' || character == '_' || character == '~';
        }

        private static boolean isAlphaOrDigit(char character) {
            return 'A' <= character && character <= 'Z' || 'a' <= character && character <= 'z' || '0' <= character && character <= '9';
        }

        static boolean isWhitespace(char character) {
            return character == ' ' || character == '\t';
        }

        @Override
        public String getLiteral() {
            return this.token.toString();
        }

        public String toString() {
            return this.token + "=>{" + this.getLiteral() + "}";
        }
    }

    private class RwsState
    extends State {
        private RwsState() {
        }

        @Override
        public State nextChar(char c) {
            if (RwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            if (c == 'O') {
                return new OrState(c);
            }
            if (c == 'A') {
                return new AndState(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class BeforePhraseOrWordRwsState
    extends State {
        private BeforePhraseOrWordRwsState() {
        }

        @Override
        public State nextChar(char c) {
            if (BeforePhraseOrWordRwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            if (c == '\"') {
                return new SearchPhraseState(c);
            }
            return new SearchWordState(c);
        }
    }

    private class BeforeSearchExpressionRwsState
    extends State {
        private BeforeSearchExpressionRwsState() {
        }

        @Override
        public State nextChar(char c) {
            if (BeforeSearchExpressionRwsState.isWhitespace(c)) {
                return this.allowed(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class OrState
    extends LiteralState {
        public OrState(char c) {
            super(SearchQueryToken.Token.OR, c);
            if (c != 'O') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.literal.length() == 1 && c == 'R') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && OrState.isWhitespace(c)) {
                this.finish();
                return new BeforeSearchExpressionRwsState();
            }
            if (OrState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() {
            if (SearchQueryToken.Token.OR.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class AndState
    extends LiteralState {
        public AndState(char c) {
            super(SearchQueryToken.Token.AND, c);
            if (c != 'A') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.literal.length() == 1 && c == 'N') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && c == 'D') {
                return this.allowed(c);
            }
            if (this.literal.length() == 3 && AndState.isWhitespace(c)) {
                this.finish();
                return new BeforeSearchExpressionRwsState();
            }
            if (AndState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() {
            if (SearchQueryToken.Token.AND.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class NotState
    extends LiteralState {
        public NotState(char c) {
            super(SearchQueryToken.Token.NOT, c);
            if (c != 'N') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.literal.length() == 1 && c == 'O') {
                return this.allowed(c);
            }
            if (this.literal.length() == 2 && c == 'T') {
                return this.allowed(c);
            }
            if (this.literal.length() == 3 && NotState.isWhitespace(c)) {
                this.finish();
                return new BeforePhraseOrWordRwsState();
            }
            if (NotState.isWhitespace(c)) {
                this.changeToken(SearchQueryToken.Token.WORD).finish();
                return new RwsState();
            }
            this.literal.append(c);
            return new SearchWordState(this);
        }

        @Override
        public State close() {
            if (SearchQueryToken.Token.NOT.name().equals(this.literal.toString())) {
                return this.finish();
            }
            return this.changeToken(SearchQueryToken.Token.WORD).finish();
        }
    }

    private class CloseState
    extends State {
        public CloseState() {
            super(SearchQueryToken.Token.CLOSE, true);
        }

        @Override
        public State nextChar(char c) {
            return new SearchExpressionState().init(c);
        }
    }

    private class OpenState
    extends State {
        public OpenState() {
            super(SearchQueryToken.Token.OPEN, true);
        }

        @Override
        public State nextChar(char c) {
            this.finish();
            if (OpenState.isWhitespace(c)) {
                return this.forbidden(c);
            }
            return new SearchExpressionState().init(c);
        }
    }

    private class SearchPhraseState
    extends LiteralState {
        private boolean closed;
        private boolean escaped;

        public SearchPhraseState(char c) {
            super(SearchQueryToken.Token.PHRASE, c);
            this.closed = false;
            this.escaped = false;
            if (c != '\"') {
                this.forbidden(c);
            }
        }

        @Override
        public State nextChar(char c) {
            if (this.closed) {
                this.finish();
                if (c == ')') {
                    return new CloseState();
                }
                if (SearchPhraseState.isWhitespace(c)) {
                    return new RwsState();
                }
            } else {
                if (this.escaped) {
                    this.escaped = false;
                    if (c == '\"' || c == '\\') {
                        return this.allowed(c);
                    }
                    return this.forbidden(c);
                }
                if (c == '\\') {
                    this.escaped = true;
                    return this;
                }
                if (SearchPhraseState.isAllowedPhrase(c)) {
                    return this.allowed(c);
                }
                if (SearchPhraseState.isWhitespace(c)) {
                    return this.allowed(c);
                }
                if (c == '\"') {
                    if (this.literal.length() == 1) {
                        return this.invalid();
                    }
                    this.closed = true;
                    return this.allowed(c);
                }
            }
            return this.forbidden(c);
        }

        @Override
        public State close() {
            if (this.closed) {
                return this.finish();
            }
            return this.invalid();
        }
    }

    private class SearchWordState
    extends LiteralState {
        public SearchWordState(char c) {
            super(SearchQueryToken.Token.WORD, c);
            if (!SearchWordState.isAllowedWord(c)) {
                this.forbidden(c);
            }
        }

        public SearchWordState(State toConsume) {
            super(SearchQueryToken.Token.WORD, toConsume.getLiteral());
            for (int i = 0; i < this.literal.length(); ++i) {
                if (SearchWordState.isAllowedWord(this.literal.charAt(i))) continue;
                this.forbidden(this.literal.charAt(i));
            }
        }

        @Override
        public State nextChar(char c) {
            if (SearchWordState.isAllowedWord(c)) {
                return this.allowed(c);
            }
            if (c == ')') {
                this.finish();
                return new CloseState();
            }
            if (SearchWordState.isWhitespace(c)) {
                this.finish();
                return new RwsState();
            }
            return this.forbidden(c);
        }

        @Override
        public State finish() {
            String tmpLiteral = this.literal.toString();
            if (tmpLiteral.length() == 3) {
                if (SearchQueryToken.Token.AND.name().equals(tmpLiteral)) {
                    return this.finishAs(SearchQueryToken.Token.AND);
                }
                if (SearchQueryToken.Token.NOT.name().equals(tmpLiteral)) {
                    return this.finishAs(SearchQueryToken.Token.NOT);
                }
            } else if (tmpLiteral.length() == 2 && SearchQueryToken.Token.OR.name().equals(tmpLiteral)) {
                return this.finishAs(SearchQueryToken.Token.OR);
            }
            return super.finish();
        }

        @Override
        public State close() {
            return this.finish();
        }
    }

    private class SearchTermState
    extends LiteralState {
        private SearchTermState() {
        }

        @Override
        public State nextChar(char c) {
            if (c == 'N') {
                return new NotState(c);
            }
            if (c == '\"') {
                return new SearchPhraseState(c);
            }
            if (SearchTermState.isAllowedWord(c)) {
                return new SearchWordState(c);
            }
            return this.forbidden(c);
        }

        @Override
        public State init(char c) {
            return this.nextChar(c);
        }
    }

    private static abstract class LiteralState
    extends State {
        protected final StringBuilder literal = new StringBuilder();

        public LiteralState() {
        }

        public LiteralState(SearchQueryToken.Token t, char c) {
            super(t);
            this.init(c);
        }

        public LiteralState(SearchQueryToken.Token t, String initLiteral) {
            super(t);
            this.literal.append(initLiteral);
        }

        @Override
        public State allowed(char c) {
            this.literal.append(c);
            return this;
        }

        @Override
        public String getLiteral() {
            return this.literal.toString();
        }

        public State init(char c) {
            if (this.isFinished()) {
                logger.error(this.toString() + " is already finished.");
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
            }
            this.literal.append(c);
            return this;
        }
    }
}

