/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.util.CdsTypeUtils;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoLocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import org.apache.olingo.odata2.api.edm.EdmAnnotatable;
import org.apache.olingo.odata2.api.edm.EdmAnnotationAttribute;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.core.edm.Bit;
import org.apache.olingo.odata2.core.edm.EdmBinary;
import org.apache.olingo.odata2.core.edm.EdmBoolean;
import org.apache.olingo.odata2.core.edm.EdmByte;
import org.apache.olingo.odata2.core.edm.EdmDateTime;
import org.apache.olingo.odata2.core.edm.EdmDateTimeOffset;
import org.apache.olingo.odata2.core.edm.EdmDecimal;
import org.apache.olingo.odata2.core.edm.EdmDouble;
import org.apache.olingo.odata2.core.edm.EdmGuid;
import org.apache.olingo.odata2.core.edm.EdmInt16;
import org.apache.olingo.odata2.core.edm.EdmInt32;
import org.apache.olingo.odata2.core.edm.EdmInt64;
import org.apache.olingo.odata2.core.edm.EdmSByte;
import org.apache.olingo.odata2.core.edm.EdmSingle;
import org.apache.olingo.odata2.core.edm.EdmString;
import org.apache.olingo.odata2.core.edm.EdmTime;
import org.apache.olingo.odata2.core.edm.Uint7;

public class TypeConverterUtils {
    private static final DateTimeFormatter DATE_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss]")).optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 6, true).optionalEnd().toFormatter();

    private TypeConverterUtils() {
    }

    public static Object convertToType(EdmType type, String value) {
        if (value == null) {
            return null;
        }
        Object typedValue = type instanceof EdmDecimal ? new BigDecimal(value) : (type instanceof EdmDouble ? Double.valueOf(Double.parseDouble(value)) : (type instanceof EdmSingle ? Float.valueOf(Float.parseFloat(value)) : (type instanceof EdmInt64 ? Long.valueOf(Long.parseLong(value)) : (type instanceof EdmInt32 || type instanceof EdmInt16 || type instanceof EdmSByte || type instanceof EdmByte || type instanceof Uint7 || type instanceof Bit ? Integer.valueOf(Integer.parseInt(value)) : (type instanceof EdmBinary ? (Object)value.getBytes(Charset.defaultCharset()) : (type instanceof EdmString ? (value.length() >= 2 && value.startsWith("'") && value.endsWith("'") ? value.substring(1, value.length() - 1) : value) : (type instanceof EdmTime ? (value.startsWith("PT") ? LocalTime.ofNanoOfDay(Duration.parse(value).toNanos()) : LocalTime.parse(value)) : (type instanceof EdmDateTime ? LocalDate.from(DATE_FORMATTER.parse(value)) : (type instanceof EdmDateTimeOffset ? ZonedDateTime.parse(value).toInstant() : (type instanceof EdmBoolean ? Boolean.valueOf(Boolean.parseBoolean(value)) : (type instanceof EdmGuid ? CdsTypeUtils.parseUuid((Object)value) : value)))))))))));
        return typedValue;
    }

    public static Object getValueBasedOnTypeOfResultSet(EdmType type, Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (type instanceof EdmTime) {
                return TypeConverterUtils.convertToEdmTimeAsCalendar(value);
            }
            if (type instanceof EdmDateTime) {
                return TypeConverterUtils.convertToEdmDateTimeAsSqlTimestamp(value);
            }
            if (type instanceof EdmDateTimeOffset) {
                return TypeConverterUtils.convertToEdmDateTimeOffsetAsSqlTimestamp(value);
            }
            if (type instanceof EdmGuid) {
                return UUID.fromString(value.toString());
            }
        }
        catch (ErrorStatusException | IllegalArgumentException | DateTimeParseException e) {
            ErrorStatusException conversionError = TypeConverterUtils.conversionError(value, TypeConverterUtils.getTypeName(type));
            conversionError.initCause(e);
            throw conversionError;
        }
        return value;
    }

    private static String getTypeName(EdmType type) {
        return type.getClass().getSimpleName().substring(3);
    }

    private static long convertToEdmDateTimeAsSqlTimestamp(Object value) {
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            LocalDateTime ldt = date.atStartOfDay();
            return TypeConverterUtils.utcMillisOfLocalDateTimeUTC(ldt);
        }
        if (value instanceof String) {
            String dateTimeString = (String)value;
            try {
                LocalDateTime ldt = LocalDateTime.parse(dateTimeString);
                return TypeConverterUtils.utcMillisOfLocalDateTimeUTC(ldt);
            }
            catch (DateTimeParseException ldt) {
                try {
                    LocalDate ld = LocalDate.parse(dateTimeString);
                    return TypeConverterUtils.utcMillisOfLocalDateTimeUTC(ld.atStartOfDay());
                }
                catch (DateTimeParseException ld) {
                    ZonedDateTime zdt = ZonedDateTime.parse(dateTimeString);
                    return zdt.toInstant().truncatedTo(ChronoUnit.MILLIS).toEpochMilli();
                }
            }
        }
        if (value instanceof Date) {
            Date sqlDate = (Date)value;
            LocalDateTime ldt = sqlDate.toLocalDate().atStartOfDay();
            return TypeConverterUtils.utcMillisOfLocalDateTimeUTC(ldt);
        }
        Timestamp ts = TypeConverterUtils.convertToEdmDateTimeOffsetAsSqlTimestamp(value);
        return ts.toInstant().truncatedTo(ChronoUnit.MILLIS).toEpochMilli();
    }

    private static Timestamp timestampOfLocalDateTimeUTC(LocalDateTime ldt) {
        return Timestamp.from(ldt.toInstant(ZoneOffset.UTC));
    }

    private static long utcMillisOfLocalDateTimeUTC(LocalDateTime ldt) {
        return ldt.toInstant(ZoneOffset.UTC).toEpochMilli();
    }

    private static Calendar convertToEdmTimeAsCalendar(Object value) {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return TypeConverterUtils.timeToCalendar(time);
        }
        if (value instanceof String) {
            String string = (String)value;
            return TypeConverterUtils.timeToCalendar(LocalTime.parse(string));
        }
        if (value instanceof Time) {
            Time time = (Time)value;
            return TypeConverterUtils.timeToCalendar(time.toLocalTime());
        }
        if (value instanceof Calendar) {
            Calendar calendar = (Calendar)value;
            return calendar;
        }
        throw TypeConverterUtils.conversionError(value, "Time");
    }

    private static ErrorStatusException conversionError(Object value, String type) {
        return new ErrorStatusException((ErrorStatus)CdsErrorStatuses.VALUE_CONVERSION_FAILED, new Object[]{value == null ? null : value.toString(), value == null ? null : value.getClass().getCanonicalName(), type});
    }

    private static Timestamp convertToEdmDateTimeOffsetAsSqlTimestamp(Object value) {
        if (value instanceof Instant) {
            Instant instant = (Instant)value;
            return Timestamp.from(instant);
        }
        if (value instanceof ZonedDateTime) {
            ZonedDateTime time = (ZonedDateTime)value;
            return Timestamp.from(time.toInstant());
        }
        if (value instanceof LocalDateTime) {
            LocalDateTime ldt = (LocalDateTime)value;
            return TypeConverterUtils.timestampOfLocalDateTimeUTC(ldt);
        }
        if (value instanceof Timestamp) {
            Timestamp timestamp = (Timestamp)value;
            return timestamp;
        }
        if (value instanceof Long) {
            Long long1 = (Long)value;
            return new Timestamp(long1);
        }
        if (value instanceof String) {
            String string = (String)value;
            ZonedDateTime zdt = ZonedDateTime.parse(string);
            return Timestamp.from(zdt.toInstant());
        }
        throw TypeConverterUtils.conversionError(value, "DateTimeOffset");
    }

    private static Calendar timeToCalendar(LocalTime time) {
        return new Calendar.Builder().set(11, time.getHour()).set(12, time.getMinute()).set(13, time.getSecond()).set(14, time.getNano() / 1000000).build();
    }

    public static Object getValueBasedOnTypeOfRequestPayload(EdmType type, EdmAnnotatable property, Object value) {
        if (value == null) {
            return null;
        }
        Comparable<ChronoLocalDate> typedValue = null;
        if (type instanceof EdmTime) {
            if (value instanceof GregorianCalendar) {
                GregorianCalendar calendar = (GregorianCalendar)value;
                typedValue = calendar.toZonedDateTime().toLocalTime();
            } else if (value instanceof Time) {
                Time time = (Time)value;
                typedValue = time.toLocalTime();
            }
        } else if (type instanceof EdmDateTime) {
            boolean isDate = TypeConverterUtils.hasDateAnnotation(property);
            if (value instanceof GregorianCalendar) {
                GregorianCalendar calendar = (GregorianCalendar)value;
                typedValue = isDate ? calendar.toZonedDateTime().toLocalDate() : calendar.toZonedDateTime().toInstant();
            } else if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                typedValue = isDate ? timestamp.toLocalDateTime().toLocalDate() : timestamp.toInstant();
            }
        } else if (type instanceof EdmDateTimeOffset) {
            if (value instanceof GregorianCalendar) {
                GregorianCalendar calendar = (GregorianCalendar)value;
                typedValue = calendar.toInstant();
            } else if (value instanceof Timestamp) {
                Timestamp timestamp = (Timestamp)value;
                typedValue = timestamp.toInstant();
            }
        } else {
            typedValue = type instanceof EdmGuid ? CdsTypeUtils.parseUuid((Object)value) : value;
        }
        return typedValue;
    }

    private static boolean hasDateAnnotation(EdmAnnotatable property) {
        try {
            if (property == null) {
                return true;
            }
            List attributes = property.getAnnotations().getAnnotationAttributes();
            if (attributes == null) {
                return false;
            }
            EdmAnnotationAttribute attribute = attributes.stream().filter(a -> Objects.equals(a.getPrefix(), "sap") && Objects.equals(a.getName(), "display-format")).findFirst().orElse(null);
            return attribute != null && Objects.equals(attribute.getText(), "Date");
        }
        catch (EdmException e) {
            return true;
        }
    }
}

