/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors.response;

import com.sap.cds.Result;
import com.sap.cds.Row;
import com.sap.cds.adapter.odata.v2.processors.ExpandWriteCallback;
import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.olingo.odata2.api.ODataCallback;
import org.apache.olingo.odata2.api.edm.EdmComplexType;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmFunctionImport;
import org.apache.olingo.odata2.api.edm.EdmMultiplicity;
import org.apache.olingo.odata2.api.edm.EdmNavigationProperty;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTypeKind;
import org.apache.olingo.odata2.api.edm.EdmTyped;

public class ResultSetProcessor {
    public static List<Map<String, Object>> postProcessResponsePayload(EdmType edmType, Result result, Map<String, ODataCallback> callbacks, URI baseUri) {
        return ResultSetProcessor.postProcessResponsePayload(edmType, result, callbacks, baseUri, false, false);
    }

    public static List<Map<String, Object>> postProcessResponsePayload(EdmType edmType, Result result, Map<String, ODataCallback> callbacks, URI baseUri, boolean generateID, boolean deferredExpand) {
        if (null == result || result.first().isEmpty()) {
            return Collections.emptyList();
        }
        return ResultSetProcessor.processResultList(edmType, result.stream().collect(Collectors.toList()), callbacks, baseUri, generateID, deferredExpand);
    }

    private static List<Map<String, Object>> processResultList(EdmType edmType, List<Map<String, Object>> list, Map<String, ODataCallback> callbacks, URI baseUri, boolean generateID, boolean deferredExpand) {
        ArrayList<Map<String, Object>> processedResultList = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> row : list) {
            if (generateID) {
                row.put("ID__", UUID.randomUUID().toString());
            }
            processedResultList.add(ResultSetProcessor.processRow(edmType, row, callbacks, baseUri, generateID, deferredExpand));
        }
        return processedResultList;
    }

    private static Map<String, Object> processProperty(EdmType edmType, String key, Object value, Map<String, ODataCallback> callbacks, URI baseUri, boolean generateID, boolean deferredExpand) {
        HashMap<String, Object> finalResult = new HashMap<String, Object>();
        if (value instanceof Map) {
            finalResult.put(key, ResultSetProcessor.processRow(edmType, (Map)value, callbacks, baseUri, generateID, deferredExpand));
        } else if (value instanceof List) {
            List<Map<String, Object>> list = ResultSetProcessor.processResultList(edmType, (List)value, callbacks, baseUri, generateID, deferredExpand);
            finalResult.put(key, list);
        } else {
            finalResult.put(key, TypeConverterUtils.getValueBasedOnTypeOfResultSet(edmType, value));
        }
        return finalResult;
    }

    private static Map<String, Object> processRow(EdmType edmType, Map<String, Object> row, Map<String, ODataCallback> callbacks, URI baseUri, boolean generateID, boolean deferredExpand) {
        HashMap<String, Object> resValue = null;
        try {
            switch (edmType.getKind()) {
                case ENTITY: {
                    EdmEntityType edmEntityType = (EdmEntityType)edmType;
                    List properties = edmEntityType.getPropertyNames();
                    List navProperties = edmEntityType.getNavigationPropertyNames();
                    resValue = new HashMap();
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        EdmType type = null;
                        if (properties.contains(key)) {
                            try {
                                EdmProperty edmProperty = (EdmProperty)edmEntityType.getProperty(key);
                                type = edmProperty.getType();
                            }
                            catch (EdmException e) {
                                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_EDM_PROPERTY, new Object[]{key, edmEntityType.getName(), e});
                            }
                        }
                        if (navProperties.contains(key)) {
                            try {
                                EdmNavigationProperty edmNavProperty = (EdmNavigationProperty)edmEntityType.getProperty(key);
                                type = edmNavProperty.getType();
                                String navigationKey = edmEntityType.getName().concat(".").concat(key);
                                callbacks.put(navigationKey, (ODataCallback)new ExpandWriteCallback(baseUri, deferredExpand));
                            }
                            catch (EdmException e) {
                                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_EDM_PROPERTY, new Object[]{key, edmEntityType.getName(), e});
                            }
                        }
                        if (type == null) continue;
                        resValue.putAll(ResultSetProcessor.processProperty(type, key, value, callbacks, baseUri, generateID, deferredExpand));
                    }
                    break;
                }
                case COMPLEX: {
                    EdmComplexType edmComplexType = (EdmComplexType)edmType;
                    List properties = edmComplexType.getPropertyNames();
                    resValue = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        EdmType type = null;
                        if (properties.contains(key)) {
                            try {
                                EdmProperty edmProperty = (EdmProperty)edmComplexType.getProperty(key);
                                type = edmProperty.getType();
                            }
                            catch (EdmException e) {
                                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.MISSING_EDM_PROPERTY, new Object[]{key, edmComplexType.getName(), e});
                            }
                        }
                        if (type == null) continue;
                        resValue.putAll(ResultSetProcessor.processProperty(type, key, value, callbacks, baseUri, generateID, deferredExpand));
                    }
                    break;
                }
                case SIMPLE: {
                    for (Map.Entry<String, Object> entry : row.entrySet()) {
                        String key = entry.getKey();
                        Object value = entry.getValue();
                        resValue = new HashMap();
                        if (value instanceof List) {
                            List list = (List)value;
                            ArrayList values = new ArrayList();
                            list.forEach(val -> values.add(TypeConverterUtils.getValueBasedOnTypeOfResultSet(edmType, val)));
                            resValue.put(key, values);
                            continue;
                        }
                        resValue.put(key, TypeConverterUtils.getValueBasedOnTypeOfResultSet(edmType, value));
                    }
                    break;
                }
                default: {
                    throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_ACTION_FUNCTION_RETURN_TYPE, new Object[]{edmType.getKind().name()});
                }
            }
        }
        catch (EdmException ex) {
            throw new IllegalStateException(ex);
        }
        return resValue;
    }

    public static String resultToString(Result result) {
        return ResultSetProcessor.findFirstValue(ResultSetProcessor.rowToMap(result.first())).toString();
    }

    public static Map<String, Object> rowToMap(Optional<Row> row) {
        if (row.isPresent()) {
            return (Map)row.get();
        }
        return Collections.emptyMap();
    }

    public static <T> T rowToSingleValue(Optional<Row> row, Class<T> type) {
        if (row.isPresent()) {
            return (T)ResultSetProcessor.findFirstValue((Map)row.get());
        }
        return null;
    }

    public static Object getReturnValueOfFunction(EdmFunctionImport functionImport, List<Map<String, Object>> data) throws EdmException {
        EdmTyped returnType = functionImport.getReturnType();
        if (returnType.getMultiplicity() == EdmMultiplicity.ONE && data.isEmpty()) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.FUNCTION_RETURN_VALUE_NOT_FOUND, new Object[]{functionImport.getName()});
        }
        if (returnType.getType().getKind() == EdmTypeKind.SIMPLE) {
            return ResultSetProcessor.findFirstValue(ResultSetProcessor.findFirstRow(data));
        }
        return returnType.getMultiplicity() == EdmMultiplicity.MANY ? data : ResultSetProcessor.findFirstRow(data);
    }

    private static Object findFirstValue(Map<String, Object> row) {
        return row.values().stream().findFirst().get();
    }

    private static Map<String, Object> findFirstRow(List<Map<String, Object>> list) {
        if (null == list || list.isEmpty()) {
            return Collections.emptyMap();
        }
        return list.get(0);
    }
}

