/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.query;

import com.sap.cds.adapter.odata.v2.search.SearchParser;
import com.sap.cds.impl.builder.model.PassThroughSearchPredicate;
import com.sap.cds.ql.Select;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.environment.CdsProperties;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.StringUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomQueryLoader {
    private static final String SEARCH_ODATA_LENIENT = "odata-lenient";
    private static final String SEARCH_PASS_THROUGH = "pass-through";
    private static final Logger logger = LoggerFactory.getLogger(CustomQueryLoader.class);

    private CustomQueryLoader() {
    }

    public static void applySystemQueryOptions(Select<?> select, Map<String, String> queryParams, CdsProperties cdsProperties) {
        String searchString = queryParams.get("search");
        if (!StringUtils.isEmpty((String)searchString)) {
            String searchMode = cdsProperties.getOdataV2().getSearchMode();
            if (SEARCH_PASS_THROUGH.equalsIgnoreCase(searchMode)) {
                select.search((CqnPredicate)new PassThroughSearchPredicate(searchString));
            } else {
                try {
                    CqnPredicate searchPredicate = new SearchParser().parse(searchString);
                    select.search(searchPredicate);
                }
                catch (ErrorStatusException e) {
                    if (SEARCH_ODATA_LENIENT.equalsIgnoreCase(searchMode)) {
                        logger.debug("Failed to parse search string, fall back to pass-through search: {}", (Object)e.getMessage());
                        select.search((CqnPredicate)new PassThroughSearchPredicate(searchString));
                    }
                    throw e;
                }
            }
        }
    }
}

