/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.sap.cds.adapter.odata.v2.CdsRequestGlobals;
import com.sap.cds.adapter.odata.v2.processors.request.CdsODataRequest;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.List;
import java.util.Objects;
import org.apache.olingo.odata2.api.edm.EdmEntityType;
import org.apache.olingo.odata2.api.edm.EdmException;
import org.apache.olingo.odata2.api.edm.EdmProperty;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.uri.UriInfo;

public class UriInfoUtils {
    private static final String PARAMETERS = "Parameters";
    private static final String TYPE = "Type";
    private static final String SET = "Set";
    private final CdsRequestGlobals globals;

    public UriInfoUtils(CdsRequestGlobals globals) {
        this.globals = Objects.requireNonNull(globals, "globals");
    }

    public static EdmProperty getSimpleProperty(UriInfo uriInfo) {
        List propertyPath = uriInfo.getPropertyPath();
        if (!propertyPath.isEmpty()) {
            return (EdmProperty)propertyPath.get(propertyPath.size() - 1);
        }
        throw new ServiceException("No property path defined", new Object[0]);
    }

    public static EdmProperty getSimpleProperty(CdsODataRequest cdsODataRequest) {
        return UriInfoUtils.getSimpleProperty(cdsODataRequest.getUriInfo());
    }

    public String getTargetEntityName(UriInfo uriInfo) {
        try {
            return this.getCdsEntityName(uriInfo.getTargetEntitySet().getEntityType());
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    private static String concat(String ns, String name) {
        return ns + "." + name;
    }

    public String getFullQualifiedName(EdmType entityType) {
        try {
            String namespace = entityType.getNamespace();
            String name = entityType.getName();
            String fqName = UriInfoUtils.concat(namespace, name);
            String cdsName = this.globals.getCdsEntityNames().get(fqName);
            if (cdsName != null) {
                fqName = cdsName;
            }
            return fqName;
        }
        catch (EdmException e) {
            throw new ServiceException((Throwable)e);
        }
    }

    public boolean isParametersEntityType(EdmEntityType entityType) {
        String name = this.getFullQualifiedName((EdmType)entityType);
        if (name.endsWith(PARAMETERS)) {
            try {
                String setName;
                if (entityType.getNavigationPropertyNames().contains(SET) && (setName = this.getFullQualifiedName(entityType.getProperty(SET).getType())).endsWith(TYPE) && name.startsWith(setName.substring(0, setName.length() - TYPE.length()))) {
                    return true;
                }
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return false;
    }

    public boolean isSetEntityType(EdmEntityType entityType) {
        String name = this.getFullQualifiedName((EdmType)entityType);
        if (name.endsWith(TYPE)) {
            try {
                String paramName;
                if (entityType.getNavigationPropertyNames().contains(PARAMETERS) && (paramName = this.getFullQualifiedName(entityType.getProperty(PARAMETERS).getType())).endsWith(PARAMETERS) && name.startsWith(paramName.substring(0, paramName.length() - PARAMETERS.length()))) {
                    return true;
                }
            }
            catch (EdmException e) {
                throw new ServiceException((Throwable)e);
            }
        }
        return false;
    }

    public String getCdsEntityName(EdmEntityType entityType) {
        String name = this.getFullQualifiedName((EdmType)entityType);
        if (this.isSetEntityType(entityType)) {
            return name.substring(0, name.length() - TYPE.length());
        }
        if (this.isParametersEntityType(entityType)) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_PARAMETERIZED_VIEW, new Object[0]);
        }
        return name;
    }
}

