/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.search;

import com.google.common.base.CharMatcher;
import com.sap.cds.adapter.odata.v2.search.SearchQueryToken;
import com.sap.cds.adapter.odata.v2.search.SearchTokenizer;
import com.sap.cds.impl.builder.model.SearchTermPredicate;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.Iterator;
import java.util.List;
import java.util.StringJoiner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchParser {
    private static final Logger logger = LoggerFactory.getLogger(SearchParser.class);
    private Iterator<SearchQueryToken> tokens;
    private SearchQueryToken token;

    private String encloseNonAsciiTermsWithQuotes(String query) {
        String[] terms = query.split(" ");
        StringJoiner joiner = new StringJoiner(" ");
        for (String term : terms) {
            Object res = term;
            boolean isAscii = CharMatcher.ascii().matchesAllOf((CharSequence)term);
            if (!isAscii && !term.startsWith("\"")) {
                res = "\"" + term + "\"";
            }
            joiner.add((CharSequence)res);
        }
        return joiner.toString();
    }

    public CqnPredicate parse(String searchQuery) {
        SearchTokenizer tokenizer = new SearchTokenizer();
        String query = this.encloseNonAsciiTermsWithQuotes(searchQuery);
        return this.parse(tokenizer.tokenize(query));
    }

    protected CqnPredicate parse(List<SearchQueryToken> tokens) {
        this.tokens = tokens.iterator();
        this.nextToken();
        if (this.token == null) {
            logger.error("No search String");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }
        CqnPredicate searchExpression = this.processSearchExpression();
        if (!this.isEof()) {
            logger.error("Token left after end of search query parsing.");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }
        return searchExpression;
    }

    private CqnPredicate processSearchExpression() {
        return this.processExprOr();
    }

    private CqnPredicate processExprOr() {
        CqnPredicate left = this.processExprAnd();
        while (this.isToken(SearchQueryToken.Token.OR)) {
            this.nextToken();
            CqnPredicate right = this.processExprAnd();
            left = CQL.or((CqnPredicate)left, (CqnPredicate)right);
        }
        return left;
    }

    private CqnPredicate processExprAnd() {
        CqnPredicate left = this.processTerm();
        while (this.isToken(SearchQueryToken.Token.AND) || this.isTerm()) {
            if (this.isToken(SearchQueryToken.Token.AND)) {
                this.nextToken();
            }
            CqnPredicate right = this.processTerm();
            left = CQL.and((CqnPredicate)left, (CqnPredicate)right);
        }
        return left;
    }

    private CqnPredicate processTerm() {
        if (this.isToken(SearchQueryToken.Token.OPEN)) {
            this.nextToken();
            CqnPredicate expr = this.processExprOr();
            this.processClose();
            return expr;
        }
        if (this.isToken(SearchQueryToken.Token.NOT)) {
            return this.processNot();
        }
        return this.processWordOrPhrase();
    }

    private void processClose() {
        if (!this.isToken(SearchQueryToken.Token.CLOSE)) {
            logger.error("Missing close bracket after open bracket.");
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
        }
        this.nextToken();
    }

    private CqnPredicate processNot() {
        this.nextToken();
        if (this.isToken(SearchQueryToken.Token.WORD) || this.isToken(SearchQueryToken.Token.PHRASE)) {
            return CQL.not((CqnPredicate)this.processWordOrPhrase());
        }
        String tokenAsString = this.getTokenAsString();
        logger.error("NOT must be followed by a term not a " + tokenAsString);
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
    }

    private CqnPredicate processWordOrPhrase() {
        if (this.isToken(SearchQueryToken.Token.PHRASE)) {
            return this.processPhrase();
        }
        if (this.isToken(SearchQueryToken.Token.WORD)) {
            return this.processWord();
        }
        String tokenName = this.getTokenAsString();
        logger.error("Expected PHRASE||WORD found: " + tokenName);
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.SEARCH_PARSING_FAILED, new Object[0]);
    }

    private CqnPredicate processWord() {
        String literal = this.token.getLiteral();
        this.nextToken();
        return new SearchTermPredicate(literal);
    }

    private CqnPredicate processPhrase() {
        String literal = this.token.getLiteral();
        this.nextToken();
        return new SearchTermPredicate(literal.substring(1, literal.length() - 1));
    }

    private boolean isTerm() {
        return this.isToken(SearchQueryToken.Token.NOT) || this.isToken(SearchQueryToken.Token.PHRASE) || this.isToken(SearchQueryToken.Token.WORD) || this.isToken(SearchQueryToken.Token.OPEN);
    }

    private boolean isEof() {
        return this.token == null;
    }

    private boolean isToken(SearchQueryToken.Token toCheckToken) {
        return this.token != null && this.token.getToken() == toCheckToken;
    }

    private void nextToken() {
        this.token = this.tokens.hasNext() ? this.tokens.next() : null;
    }

    private String getTokenAsString() {
        return this.token == null ? "<EOF>" : this.token.getToken().name();
    }
}

