/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.processors.response;

import com.sap.cds.Result;
import com.sap.cds.adapter.odata.v2.query.NextLinkInfo;
import com.sap.cds.services.ServiceException;

public class CdsODataResponse {
    private final int statusCode;
    private final Result result;
    private final NextLinkInfo nextLinkInfo;
    private final String mimeType;
    private final boolean generateID;
    private Exception exception;

    public CdsODataResponse(int statusCode, Result result) {
        this(statusCode, result, null, null, false);
    }

    public CdsODataResponse(int statusCode, Result result, NextLinkInfo nextLinkInfo, String mimeType, boolean generateID) {
        this.statusCode = statusCode;
        this.result = result;
        this.nextLinkInfo = nextLinkInfo;
        this.mimeType = mimeType;
        this.generateID = generateID;
    }

    public CdsODataResponse(Exception e) {
        int n;
        if (e instanceof ServiceException) {
            ServiceException se = (ServiceException)((Object)e);
            n = se.getErrorStatus().getHttpStatus();
        } else {
            n = 500;
        }
        this(n, null);
        this.exception = e;
    }

    public boolean isSuccess() {
        return this.statusCode < 400;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public Result getResult() {
        return this.result;
    }

    public NextLinkInfo getNextLinkInfo() {
        return this.nextLinkInfo;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public boolean generateID() {
        return this.generateID;
    }

    public Exception getException() {
        return this.exception;
    }
}

