/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.query;

import com.sap.cds.adapter.odata.v2.utils.TypeConverterUtils;
import com.sap.cds.impl.builder.model.CqnNull;
import com.sap.cds.ql.CQL;
import com.sap.cds.ql.ElementRef;
import com.sap.cds.ql.Predicate;
import com.sap.cds.ql.Value;
import com.sap.cds.ql.cqn.CqnElementRef;
import com.sap.cds.ql.cqn.CqnPredicate;
import com.sap.cds.ql.cqn.CqnValue;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ErrorStatuses;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.olingo.odata2.api.edm.EdmLiteral;
import org.apache.olingo.odata2.api.edm.EdmType;
import org.apache.olingo.odata2.api.edm.EdmTyped;
import org.apache.olingo.odata2.api.uri.expression.BinaryExpression;
import org.apache.olingo.odata2.api.uri.expression.BinaryOperator;
import org.apache.olingo.odata2.api.uri.expression.ExpressionVisitor;
import org.apache.olingo.odata2.api.uri.expression.FilterExpression;
import org.apache.olingo.odata2.api.uri.expression.LiteralExpression;
import org.apache.olingo.odata2.api.uri.expression.MemberExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodExpression;
import org.apache.olingo.odata2.api.uri.expression.MethodOperator;
import org.apache.olingo.odata2.api.uri.expression.OrderByExpression;
import org.apache.olingo.odata2.api.uri.expression.OrderExpression;
import org.apache.olingo.odata2.api.uri.expression.PropertyExpression;
import org.apache.olingo.odata2.api.uri.expression.SortOrder;
import org.apache.olingo.odata2.api.uri.expression.UnaryExpression;
import org.apache.olingo.odata2.api.uri.expression.UnaryOperator;
import org.apache.olingo.odata2.core.edm.EdmNull;

public class ExpressionToCqnVisitor
implements ExpressionVisitor {
    private static final String NULL_KEYWORD = "null";
    private boolean caseInsensitive = false;

    public ExpressionToCqnVisitor(boolean caseInsensitive) {
        this.caseInsensitive = caseInsensitive;
    }

    public Object visitBinary(BinaryExpression binaryExpression, BinaryOperator operator, Object left, Object right) {
        switch (operator) {
            case AND: {
                return ((Predicate)left).and((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
            }
            case OR: {
                return ((Predicate)left).or((CqnPredicate)((Predicate)right), new CqnPredicate[0]);
            }
            case EQ: {
                if (left instanceof Predicate) {
                    Predicate lhs = (Predicate)left;
                    if (right instanceof Predicate) {
                        Predicate rhs = (Predicate)right;
                        Predicate bothTrue = lhs.and((CqnPredicate)rhs, new CqnPredicate[0]);
                        Predicate bothFalse = lhs.not().and((CqnPredicate)rhs.not(), new CqnPredicate[0]);
                        return bothTrue.or((CqnPredicate)bothFalse, new CqnPredicate[0]);
                    }
                }
                return ((Value)left).is((Value)right);
            }
            case NE: {
                if (left instanceof Predicate) {
                    Predicate lhs = (Predicate)left;
                    if (right instanceof Predicate) {
                        Predicate rhs = (Predicate)right;
                        Predicate eitherTrue = lhs.or((CqnPredicate)rhs, new CqnPredicate[0]);
                        Predicate eitherFalse = lhs.not().or((CqnPredicate)rhs.not(), new CqnPredicate[0]);
                        return eitherTrue.and((CqnPredicate)eitherFalse, new CqnPredicate[0]);
                    }
                }
                return ((Value)left).isNot((Value)right);
            }
            case GE: {
                return ((Value)left).ge(right);
            }
            case GT: {
                return ((Value)left).gt(right);
            }
            case LE: {
                return ((Value)left).le(right);
            }
            case LT: {
                return ((Value)left).lt(right);
            }
            case ADD: {
                return ((Value)left).plus((Value)right);
            }
            case SUB: {
                return ((Value)left).minus((Value)right);
            }
            case MUL: {
                return ((Value)left).times((Value)right);
            }
            case DIV: {
                return ((Value)left).dividedBy((Value)right);
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_OPERATOR, new Object[]{operator});
    }

    public Object visitUnary(UnaryExpression unaryExpression, UnaryOperator operator, Object operand) {
        switch (operator) {
            case NOT: {
                return ((Predicate)operand).not();
            }
        }
        throw new ErrorStatusException((ErrorStatus)ErrorStatuses.NOT_IMPLEMENTED, new Object[0]);
    }

    public Object visitMethod(MethodExpression methodExpression, MethodOperator methodCall, List<Object> parameters) {
        String func;
        Value value = (Value)parameters.get(0);
        switch (func = methodCall.name().toUpperCase(Locale.US)) {
            case "TOUPPER": {
                return value.toUpper();
            }
            case "TOLOWER": {
                return value.toLower();
            }
            case "LENGTH": 
            case "TRIM": {
                return CQL.func((String)methodCall.name(), (CqnValue[])new CqnValue[]{value});
            }
            case "SUBSTRING": {
                Value start = null;
                if (parameters.size() >= 2) {
                    start = (Value)parameters.get(1);
                }
                switch (parameters.size()) {
                    case 2: {
                        return value.substring(start);
                    }
                    case 3: {
                        Value length = (Value)parameters.get(2);
                        return value.substring(start, length);
                    }
                }
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_SUBSTRING, new Object[0]);
            }
            case "CONTAINS": {
                Value substring = (Value)parameters.get(1);
                return CQL.contains((CqnValue)value, (CqnValue)substring, (boolean)this.caseInsensitive);
            }
            case "STARTSWITH": {
                Value prefix = (Value)parameters.get(1);
                return CQL.startsWith((CqnValue)value, (CqnValue)prefix, (boolean)this.caseInsensitive);
            }
            case "ENDSWITH": {
                Value suffix = (Value)parameters.get(1);
                return CQL.endsWith((CqnValue)value, (CqnValue)suffix, (boolean)this.caseInsensitive);
            }
            case "SUBSTRINGOF": {
                Value searchstring = (Value)parameters.get(1);
                return searchstring.contains(value, this.caseInsensitive);
            }
            case "REPLACE": {
                Value oldString = (Value)parameters.get(1);
                Value replacementString = (Value)parameters.get(2);
                return CQL.func((String)methodCall.name(), (CqnValue[])new CqnValue[]{value, oldString, replacementString});
            }
        }
        throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.UNSUPPORTED_METHOD, new Object[]{func});
    }

    public Value<?> visitLiteral(LiteralExpression literal, EdmLiteral edmLiteral) {
        if (NULL_KEYWORD.equals(edmLiteral.getLiteral()) || edmLiteral.getType() instanceof EdmNull) {
            return CqnNull.getInstance();
        }
        Object literalValue = TypeConverterUtils.convertToType((EdmType)edmLiteral.getType(), edmLiteral.getLiteral());
        return CQL.val((Object)literalValue);
    }

    public ElementRef<?> visitMember(MemberExpression member, Object path, Object property) {
        if (path instanceof CqnElementRef) {
            CqnElementRef p1 = (CqnElementRef)path;
            if (property instanceof CqnElementRef) {
                CqnElementRef p2 = (CqnElementRef)property;
                ArrayList segments = new ArrayList(p1.size() + p2.size());
                segments.addAll(p1.segments());
                segments.addAll(p2.segments());
                return CQL.get(segments);
            }
        }
        throw new UnsupportedOperationException("Currently only members of type 'CqnElementRef' are supported.");
    }

    public Object visitFilterExpression(FilterExpression filterExpression, String expressionString, Object expression) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Object visitOrderByExpression(OrderByExpression orderByExpression, String expressionString, List<Object> orders) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public Object visitOrder(OrderExpression orderExpression, Object filterResult, SortOrder sortOrder) {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public ElementRef<?> visitProperty(PropertyExpression propertyExpression, String uriLiteral, EdmTyped edmProperty) {
        return CQL.get((String)uriLiteral);
    }
}

