/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.metadata.model;

import com.sap.cds.adapter.odata.v2.metadata.MetadataInfo;
import com.sap.cds.adapter.odata.v2.metadata.ODataV2EdmProvider;
import com.sap.cds.adapter.odata.v2.metadata.model.AbstractEdmxProviderAccessor;
import com.sap.cds.services.ErrorStatus;
import com.sap.cds.services.ServiceException;
import com.sap.cds.services.request.RequestContext;
import com.sap.cds.services.runtime.CdsRuntime;
import com.sap.cds.services.utils.CdsErrorStatuses;
import com.sap.cds.services.utils.ErrorStatusException;
import com.sap.cds.services.utils.LocaleUtils;
import com.sap.cds.services.utils.lib.mtx.MetaDataAccessor;
import com.sap.cds.services.utils.lib.mtx.ModelId;
import com.sap.cds.services.utils.model.DynamicModelUtils;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicEdmxProviderAccessor
extends AbstractEdmxProviderAccessor {
    private static final String V2 = "v2";
    private static Logger log = LoggerFactory.getLogger(DynamicEdmxProviderAccessor.class);
    private final CdsRuntime runtime;
    private final DynamicModelUtils utils;
    private final MetaDataAccessor<MetadataInfo> accessor;

    public DynamicEdmxProviderAccessor(CdsRuntime runtime) {
        this.runtime = runtime;
        this.utils = new DynamicModelUtils(runtime);
        this.accessor = this.utils.createMetadataAccessor((edmx, service) -> {
            ODataV2EdmProvider edmProvider;
            byte[] edmxBytes = edmx.getBytes(StandardCharsets.UTF_8);
            try {
                edmProvider = this.loadMetadataFiles(service, edmxBytes);
            }
            catch (Exception e) {
                throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.INVALID_METADATA_V2_DYNAMIC, new Object[]{service, e});
            }
            String etag = this.calculateMetadataEtag(edmxBytes);
            return new MetadataInfo(edmxBytes, edmProvider, etag);
        }, null, null);
    }

    @Override
    public MetadataInfo getMetadataInfo(String serviceName) {
        RequestContext requestContext = RequestContext.getCurrent((CdsRuntime)this.runtime);
        Locale locale = requestContext.getParameterInfo().getLocale();
        String localeString = locale != null ? LocaleUtils.getLocaleForBundle((Locale)locale).toString() : Locale.ENGLISH.getLanguage();
        ModelId modelId = this.utils.prepareModelId(requestContext.getUserInfo(), requestContext.getFeatureTogglesInfo()).odata(serviceName, localeString, V2).build();
        log.debug("Retrieving model for service name '{}', locale '{}' and features {}", new Object[]{serviceName, localeString, modelId.getFeatures()});
        try {
            return (MetadataInfo)this.accessor.getEdmx(modelId, Integer.MAX_VALUE);
        }
        catch (ServiceException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new ErrorStatusException((ErrorStatus)CdsErrorStatuses.EDMX_READ_FAILED, new Object[]{serviceName, t});
        }
    }
}

