/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v2.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonFactoryBuilder;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.json.JsonWriteFeature;
import com.sap.cds.ql.cqn.CqnReference;
import com.sap.cds.services.messages.Message;
import com.sap.cds.services.messages.MessageTarget;
import com.sap.cds.services.messages.Messages;
import com.sap.cds.services.utils.ODataUtils;
import com.sap.cds.services.utils.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.olingo.odata2.core.commons.ContentType;
import org.apache.olingo.odata2.core.commons.XmlHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessagesUtils {
    private static final Logger logger = LoggerFactory.getLogger(MessagesUtils.class);
    private static final String CODE = "code";
    private static final String DETAILS = "details";
    private static final String MESSAGE = "message";
    private static final String SEVERITY = "severity";
    private static final String TARGET = "target";
    private static final String ENTRY = "entry";
    private static final String FEED = "feed";

    public static String getSapMessagesHeader(Messages messages, String contentType) {
        ContentType ct = ContentType.parse((String)contentType);
        String actualContentType = ct.getType() + "/" + ct.getSubtype();
        if (actualContentType.equalsIgnoreCase(ContentType.APPLICATION_JSON.toContentTypeString())) {
            return MessagesUtils.getSapMessagesHeaderJson(messages);
        }
        if (actualContentType.equalsIgnoreCase(ContentType.APPLICATION_ATOM_XML.toContentTypeString()) || actualContentType.equalsIgnoreCase(ContentType.APPLICATION_XML.toContentTypeString())) {
            return MessagesUtils.getSapMessagesHeadersXML(messages);
        }
        return null;
    }

    private static String getSapMessagesHeadersXML(Messages messages) {
        if (messages.stream().count() > 0L) {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            try {
                boolean isFeed;
                XMLStreamWriter writer = XmlHelper.getXMLOutputFactory().createXMLStreamWriter(outputStream, "utf-8");
                Iterator iterator = messages.stream().iterator();
                boolean bl = isFeed = messages.stream().count() > 1L;
                if (isFeed) {
                    writer.writeStartElement(FEED);
                }
                while (iterator.hasNext()) {
                    Message message = (Message)iterator.next();
                    writer.writeStartElement(ENTRY);
                    writer.writeStartElement(CODE);
                    writer.writeCharacters(MessagesUtils.getMessageCode(message));
                    writer.writeEndElement();
                    writer.writeStartElement(MESSAGE);
                    writer.writeCharacters(message.getMessage());
                    writer.writeEndElement();
                    writer.writeStartElement(SEVERITY);
                    writer.writeCharacters(String.valueOf(message.getSeverity().toString().toLowerCase(Locale.US)));
                    writer.writeEndElement();
                    String target = MessagesUtils.getTarget(message.getTarget());
                    if (target != null) {
                        writer.writeStartElement(TARGET);
                        writer.writeCharacters(target);
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                }
                if (isFeed) {
                    writer.writeEndElement();
                }
                writer.close();
                if (outputStream.size() != 0) {
                    return outputStream.toString("UTF-8");
                }
            }
            catch (UnsupportedEncodingException | XMLStreamException e) {
                logger.error("Failed to create sap messages header", (Throwable)e);
            }
        }
        return null;
    }

    private static void writeJsonMessageBody(Message message, JsonGenerator json) throws IOException {
        json.writeStringField(CODE, MessagesUtils.getMessageCode(message));
        json.writeStringField(MESSAGE, message.getMessage());
        json.writeStringField(SEVERITY, message.getSeverity().toString().toLowerCase(Locale.US));
        String target = MessagesUtils.getTarget(message.getTarget());
        if (target != null) {
            json.writeStringField(TARGET, target);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getSapMessagesHeaderJson(Messages messages) {
        List msgList = messages.stream().collect(Collectors.toList());
        if (msgList.size() <= 0) return null;
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        JsonFactoryBuilder builder = new JsonFactoryBuilder().configure(JsonWriteFeature.ESCAPE_NON_ASCII, true);
        try (JsonGenerator json = new JsonFactory(builder).createGenerator((OutputStream)outputStream);){
            json.writeStartObject();
            Message leadingMessage = (Message)msgList.remove(0);
            MessagesUtils.writeJsonMessageBody(leadingMessage, json);
            boolean isFirst = true;
            Iterator iterator = msgList.iterator();
            if (iterator.hasNext()) {
                json.writeFieldName(DETAILS);
                while (iterator.hasNext()) {
                    if (isFirst) {
                        json.writeStartArray();
                        isFirst = false;
                    }
                    Message detailMessage = (Message)iterator.next();
                    json.writeStartObject();
                    MessagesUtils.writeJsonMessageBody(detailMessage, json);
                    json.writeEndObject();
                }
                if (!isFirst) {
                    json.writeEndArray();
                }
            }
            json.writeEndObject();
            json.close();
            if (outputStream.size() == 0) return null;
            String string = outputStream.toString(StandardCharsets.UTF_8);
            return string;
        }
        catch (IOException e) {
            logger.error("Failed to create sap messages header", (Throwable)e);
        }
        return null;
    }

    public static String getMessageCode(Message message) {
        return StringUtils.isEmpty((String)message.getCode()) ? "<none>" : message.getCode();
    }

    public static String getTarget(MessageTarget messageTarget) {
        if (messageTarget == null) {
            return null;
        }
        return ODataUtils.toODataTarget(null, (String)messageTarget.getParameter(), (CqnReference)messageTarget.getRef(), (boolean)true, (boolean)false);
    }
}

