/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata;

import java.util.Collection;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.processor.MetadataProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.uri.UriInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMetadataProcessor
implements MetadataProcessor {
    static final Logger logger = LoggerFactory.getLogger(CustomMetadataProcessor.class);
    OData odata = null;
    ServiceMetadata serviceMetadata = null;

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void readMetadata(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        boolean isNotModified = false;
        ServiceMetadataETagSupport eTagSupport = this.serviceMetadata.getServiceMetadataETagSupport();
        if (eTagSupport != null && eTagSupport.getMetadataETag() != null) {
            response.setHeader("ETag", eTagSupport.getMetadataETag());
            ETagHelper eTagHelper = this.odata.createETagHelper();
            isNotModified = eTagHelper.checkReadPreconditions(eTagSupport.getMetadataETag(), (Collection)request.getHeaders("If-Match"), (Collection)request.getHeaders("If-None-Match"));
            response.setHeader("Cache-Control", "max-age=0");
        }
        if (isNotModified) {
            response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        } else if (HttpMethod.HEAD == request.getMethod()) {
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        } else {
            ODataSerializer serializer = this.odata.createSerializer(responseFormat);
            response.setContent(serializer.metadataDocument(this.serviceMetadata).getContent());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", responseFormat.toContentTypeString());
        }
    }
}

