/*
 * Decompiled with CFR 0.152.
 */
package com.sap.cds.adapter.odata.v4.metadata;

import com.sap.cds.adapter.odata.v4.utils.ODataUtils;
import com.sap.cds.feature.config.Properties;
import java.util.Collection;
import org.apache.olingo.commons.api.format.ContentType;
import org.apache.olingo.commons.api.http.HttpMethod;
import org.apache.olingo.commons.api.http.HttpStatusCode;
import org.apache.olingo.server.api.OData;
import org.apache.olingo.server.api.ODataApplicationException;
import org.apache.olingo.server.api.ODataLibraryException;
import org.apache.olingo.server.api.ODataRequest;
import org.apache.olingo.server.api.ODataResponse;
import org.apache.olingo.server.api.ServiceMetadata;
import org.apache.olingo.server.api.etag.ETagHelper;
import org.apache.olingo.server.api.etag.ServiceMetadataETagSupport;
import org.apache.olingo.server.api.processor.ServiceDocumentProcessor;
import org.apache.olingo.server.api.serializer.ODataSerializer;
import org.apache.olingo.server.api.uri.UriInfo;

public class CustomServiceDocumentProcessor
implements ServiceDocumentProcessor {
    OData odata = null;
    ServiceMetadata serviceMetadata = null;

    public void init(OData odata, ServiceMetadata serviceMetadata) {
        this.odata = odata;
        this.serviceMetadata = serviceMetadata;
    }

    public void readServiceDocument(ODataRequest request, ODataResponse response, UriInfo uriInfo, ContentType responseFormat) throws ODataApplicationException, ODataLibraryException {
        boolean isNotModified = false;
        ServiceMetadataETagSupport eTagSupport = this.serviceMetadata.getServiceMetadataETagSupport();
        if (eTagSupport != null && eTagSupport.getServiceDocumentETag() != null) {
            response.setHeader("ETag", eTagSupport.getServiceDocumentETag());
            ETagHelper eTagHelper = this.odata.createETagHelper();
            isNotModified = eTagHelper.checkReadPreconditions(eTagSupport.getServiceDocumentETag(), (Collection)request.getHeaders("If-Match"), (Collection)request.getHeaders("If-None-Match"));
            response.setHeader("Cache-Control", "max-age=0");
        }
        if (isNotModified) {
            response.setStatusCode(HttpStatusCode.NOT_MODIFIED.getStatusCode());
        } else if (HttpMethod.HEAD == request.getMethod()) {
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
        } else {
            ODataSerializer serializer = ODataUtils.createSerializer(this.odata, request, responseFormat);
            String baseUri = Properties.getCds().getOdataV4().isContextAbsoluteUrl() ? request.getRawBaseUri() : null;
            response.setContent(serializer.serviceDocument(this.serviceMetadata, baseUri).getContent());
            response.setStatusCode(HttpStatusCode.OK.getStatusCode());
            response.setHeader("Content-Type", responseFormat.toContentTypeString());
        }
    }
}

